/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.config;

import com.amazon.opendistroforelasticsearch.sql.expression.DSL;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.AggregatorFunction;
import com.amazon.opendistroforelasticsearch.sql.expression.datetime.DateTimeFunction;
import com.amazon.opendistroforelasticsearch.sql.expression.datetime.IntervalClause;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionRepository;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionResolver;
import com.amazon.opendistroforelasticsearch.sql.expression.operator.arthmetic.ArithmeticFunction;
import com.amazon.opendistroforelasticsearch.sql.expression.operator.arthmetic.MathematicalFunction;
import com.amazon.opendistroforelasticsearch.sql.expression.operator.convert.TypeCastOperator;
import com.amazon.opendistroforelasticsearch.sql.expression.operator.predicate.BinaryPredicateOperator;
import com.amazon.opendistroforelasticsearch.sql.expression.operator.predicate.UnaryPredicateOperator;
import com.amazon.opendistroforelasticsearch.sql.expression.text.TextFunction;
import com.amazon.opendistroforelasticsearch.sql.expression.window.WindowFunctions;
import java.util.HashMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExpressionConfig {
    @Bean
    public BuiltinFunctionRepository functionRepository() {
        BuiltinFunctionRepository builtinFunctionRepository = new BuiltinFunctionRepository(new HashMap<FunctionName, FunctionResolver>());
        ArithmeticFunction.register(builtinFunctionRepository);
        BinaryPredicateOperator.register(builtinFunctionRepository);
        MathematicalFunction.register(builtinFunctionRepository);
        UnaryPredicateOperator.register(builtinFunctionRepository);
        AggregatorFunction.register(builtinFunctionRepository);
        DateTimeFunction.register(builtinFunctionRepository);
        IntervalClause.register(builtinFunctionRepository);
        WindowFunctions.register(builtinFunctionRepository);
        TextFunction.register(builtinFunctionRepository);
        TypeCastOperator.register(builtinFunctionRepository);
        return builtinFunctionRepository;
    }

    @Bean
    public DSL dsl(BuiltinFunctionRepository repository) {
        return new DSL(repository);
    }
}

