/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.conditional.cases;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.ExpressionNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.expression.FunctionExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.env.Environment;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.Generated;

public class WhenClause
extends FunctionExpression {
    private final Expression condition;
    private final Expression result;

    public WhenClause(Expression condition, Expression result) {
        super(FunctionName.of("when"), (List<Expression>)ImmutableList.of((Object)condition, (Object)result));
        this.condition = condition;
        this.result = result;
    }

    public boolean isTrue(Environment<Expression, ExprValue> valueEnv) {
        ExprValue result = this.condition.valueOf(valueEnv);
        if (result.isMissing() || result.isNull()) {
            return false;
        }
        return result.booleanValue();
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        return this.result.valueOf(valueEnv);
    }

    @Override
    public ExprType type() {
        return this.result.type();
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return visitor.visitWhen(this, context);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhenClause)) {
            return false;
        }
        WhenClause other = (WhenClause)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$condition = this.getCondition();
        Expression other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Expression this$result = this.getResult();
        Expression other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WhenClause;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Expression $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    @Generated
    public Expression getCondition() {
        return this.condition;
    }

    @Generated
    public Expression getResult() {
        return this.result;
    }

    @Override
    @Generated
    public String toString() {
        return "WhenClause(condition=" + this.getCondition() + ", result=" + this.getResult() + ")";
    }
}

