/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.aggregation;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprNullValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValueUtils;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.exception.ExpressionEvaluationException;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.AggregationState;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.utils.ExpressionUtils;
import java.util.List;
import java.util.Locale;

public class SumAggregator
extends Aggregator<SumState> {
    public SumAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.SUM.getName(), arguments, returnType);
    }

    @Override
    public SumState create() {
        return new SumState(this.returnType);
    }

    @Override
    protected SumState iterate(ExprValue value, SumState state) {
        state.isEmptyCollection = false;
        state.add(value);
        return state;
    }

    public String toString() {
        return String.format(Locale.ROOT, "sum(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class SumState
    implements AggregationState {
        private final ExprCoreType type;
        private ExprValue sumResult;
        private boolean isEmptyCollection;

        SumState(ExprCoreType type) {
            this.type = type;
            this.sumResult = ExprValueUtils.integerValue(0);
            this.isEmptyCollection = true;
        }

        public void add(ExprValue value) {
            switch (this.type) {
                case INTEGER: {
                    this.sumResult = ExprValueUtils.integerValue(ExprValueUtils.getIntegerValue(this.sumResult) + ExprValueUtils.getIntegerValue(value));
                    break;
                }
                case LONG: {
                    this.sumResult = ExprValueUtils.longValue(ExprValueUtils.getLongValue(this.sumResult) + ExprValueUtils.getLongValue(value));
                    break;
                }
                case FLOAT: {
                    this.sumResult = ExprValueUtils.floatValue(Float.valueOf(ExprValueUtils.getFloatValue(this.sumResult).floatValue() + ExprValueUtils.getFloatValue(value).floatValue()));
                    break;
                }
                case DOUBLE: {
                    this.sumResult = ExprValueUtils.doubleValue(ExprValueUtils.getDoubleValue(this.sumResult) + ExprValueUtils.getDoubleValue(value));
                    break;
                }
                default: {
                    throw new ExpressionEvaluationException(String.format("unexpected type [%s] in sum aggregation", this.type));
                }
            }
        }

        @Override
        public ExprValue result() {
            return this.isEmptyCollection ? ExprNullValue.of() : this.sumResult;
        }
    }
}

