/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.aggregation;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValueUtils;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.AggregationState;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.utils.ExpressionUtils;
import java.util.List;

public class MinAggregator
extends Aggregator<MinState> {
    public MinAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.MIN.getName(), arguments, returnType);
    }

    @Override
    public MinState create() {
        return new MinState();
    }

    @Override
    protected MinState iterate(ExprValue value, MinState state) {
        state.min(value);
        return state;
    }

    public String toString() {
        return String.format("min(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class MinState
    implements AggregationState {
        private ExprValue minResult = ExprValueUtils.LITERAL_NULL;

        MinState() {
        }

        public void min(ExprValue value) {
            this.minResult = this.minResult.isNull() ? value : (this.minResult.compareTo(value) < 0 ? this.minResult : value);
        }

        @Override
        public ExprValue result() {
            return this.minResult;
        }
    }
}

