/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.aggregation;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValueUtils;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.AggregationState;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.utils.ExpressionUtils;
import java.util.List;

public class MaxAggregator
extends Aggregator<MaxState> {
    public MaxAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.MAX.getName(), arguments, returnType);
    }

    @Override
    public MaxState create() {
        return new MaxState();
    }

    @Override
    protected MaxState iterate(ExprValue value, MaxState state) {
        state.max(value);
        return state;
    }

    public String toString() {
        return String.format("max(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class MaxState
    implements AggregationState {
        private ExprValue maxResult = ExprValueUtils.LITERAL_NULL;

        MaxState() {
        }

        public void max(ExprValue value) {
            this.maxResult = this.maxResult.isNull() ? value : (this.maxResult.compareTo(value) > 0 ? this.maxResult : value);
        }

        @Override
        public ExprValue result() {
            return this.maxResult;
        }
    }
}

