/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.aggregation;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValueUtils;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.AggregationState;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.utils.ExpressionUtils;
import java.util.List;
import java.util.Locale;

public class CountAggregator
extends Aggregator<CountState> {
    public CountAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.COUNT.getName(), arguments, returnType);
    }

    @Override
    public CountState create() {
        return new CountState();
    }

    @Override
    protected CountState iterate(ExprValue value, CountState state) {
        state.count++;
        return state;
    }

    public String toString() {
        return String.format(Locale.ROOT, "count(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class CountState
    implements AggregationState {
        private int count = 0;

        CountState() {
        }

        @Override
        public ExprValue result() {
            return ExprValueUtils.integerValue(this.count);
        }
    }
}

