/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.aggregation;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprNullValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValueUtils;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.AggregationState;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.utils.ExpressionUtils;
import java.util.List;
import java.util.Locale;

public class AvgAggregator
extends Aggregator<AvgState> {
    public AvgAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.AVG.getName(), arguments, returnType);
    }

    @Override
    public AvgState create() {
        return new AvgState();
    }

    @Override
    protected AvgState iterate(ExprValue value, AvgState state) {
        state.count++;
        state.total += ExprValueUtils.getDoubleValue(value);
        return state;
    }

    public String toString() {
        return String.format(Locale.ROOT, "avg(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class AvgState
    implements AggregationState {
        private int count = 0;
        private double total = 0.0;

        AvgState() {
        }

        @Override
        public ExprValue result() {
            return this.count == 0 ? ExprNullValue.of() : ExprValueUtils.doubleValue(this.total / (double)this.count);
        }
    }
}

