/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.aggregation;

import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.AvgAggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.CountAggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.MaxAggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.MinAggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.SumAggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionRepository;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionBuilder;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionResolver;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionSignature;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class AggregatorFunction {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(AggregatorFunction.avg());
        repository.register(AggregatorFunction.sum());
        repository.register(AggregatorFunction.count());
        repository.register(AggregatorFunction.min());
        repository.register(AggregatorFunction.max());
    }

    private static FunctionResolver avg() {
        FunctionName functionName = BuiltinFunctionName.AVG.getName();
        return new FunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), arguments -> new AvgAggregator(arguments, ExprCoreType.DOUBLE)).build());
    }

    private static FunctionResolver count() {
        FunctionName functionName = BuiltinFunctionName.COUNT.getName();
        FunctionResolver functionResolver = new FunctionResolver(functionName, ExprCoreType.coreTypes().stream().collect(Collectors.toMap(type -> new FunctionSignature(functionName, Collections.singletonList(type)), type -> arguments -> new CountAggregator(arguments, ExprCoreType.INTEGER))));
        return functionResolver;
    }

    private static FunctionResolver sum() {
        FunctionName functionName = BuiltinFunctionName.SUM.getName();
        return new FunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), arguments -> new SumAggregator(arguments, ExprCoreType.INTEGER)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), arguments -> new SumAggregator(arguments, ExprCoreType.LONG)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), arguments -> new SumAggregator(arguments, ExprCoreType.FLOAT)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), arguments -> new SumAggregator(arguments, ExprCoreType.DOUBLE)).build());
    }

    private static FunctionResolver min() {
        FunctionName functionName = BuiltinFunctionName.MIN.getName();
        return new FunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), arguments -> new MinAggregator(arguments, ExprCoreType.INTEGER)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), arguments -> new MinAggregator(arguments, ExprCoreType.LONG)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), arguments -> new MinAggregator(arguments, ExprCoreType.FLOAT)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), arguments -> new MinAggregator(arguments, ExprCoreType.DOUBLE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.STRING)), arguments -> new MinAggregator(arguments, ExprCoreType.STRING)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATE)), arguments -> new MinAggregator(arguments, ExprCoreType.DATE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATETIME)), arguments -> new MinAggregator(arguments, ExprCoreType.DATETIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIME)), arguments -> new MinAggregator(arguments, ExprCoreType.TIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIMESTAMP)), arguments -> new MinAggregator(arguments, ExprCoreType.TIMESTAMP)).build());
    }

    private static FunctionResolver max() {
        FunctionName functionName = BuiltinFunctionName.MAX.getName();
        return new FunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), arguments -> new MaxAggregator(arguments, ExprCoreType.INTEGER)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), arguments -> new MaxAggregator(arguments, ExprCoreType.LONG)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), arguments -> new MaxAggregator(arguments, ExprCoreType.FLOAT)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), arguments -> new MaxAggregator(arguments, ExprCoreType.DOUBLE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.STRING)), arguments -> new MaxAggregator(arguments, ExprCoreType.STRING)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATE)), arguments -> new MaxAggregator(arguments, ExprCoreType.DATE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATETIME)), arguments -> new MaxAggregator(arguments, ExprCoreType.DATETIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIME)), arguments -> new MaxAggregator(arguments, ExprCoreType.TIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIMESTAMP)), arguments -> new MaxAggregator(arguments, ExprCoreType.TIMESTAMP)).build());
    }

    @Generated
    private AggregatorFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

