/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression;

import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.FunctionExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.LiteralExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.NamedExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.ReferenceExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.NamedAggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.conditional.cases.CaseClause;
import com.amazon.opendistroforelasticsearch.sql.expression.conditional.cases.WhenClause;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionImplementation;

public abstract class ExpressionNodeVisitor<T, C> {
    public T visitNode(Expression node, C context) {
        return null;
    }

    public T visitChildren(FunctionImplementation node, C context) {
        T result = this.defaultResult();
        for (Expression child : node.getArguments()) {
            Object childResult = child.accept(this, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    private T defaultResult() {
        return null;
    }

    private T aggregateResult(T aggregate, T nextResult) {
        return nextResult;
    }

    public T visitLiteral(LiteralExpression node, C context) {
        return this.visitNode(node, context);
    }

    public T visitNamed(NamedExpression node, C context) {
        return node.getDelegated().accept(this, context);
    }

    public T visitReference(ReferenceExpression node, C context) {
        return this.visitNode(node, context);
    }

    public T visitFunction(FunctionExpression node, C context) {
        return this.visitChildren(node, context);
    }

    public T visitAggregator(Aggregator<?> node, C context) {
        return this.visitChildren(node, context);
    }

    public T visitNamedAggregator(NamedAggregator node, C context) {
        return this.visitChildren(node, context);
    }

    public T visitCase(CaseClause node, C context) {
        return this.visitFunction(node, context);
    }

    public T visitWhen(WhenClause node, C context) {
        return this.visitFunction(node, context);
    }
}

