/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.executor;

import com.amazon.opendistroforelasticsearch.sql.ast.tree.Sort;
import com.amazon.opendistroforelasticsearch.sql.executor.ExecutionEngine;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.ReferenceExpression;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.AggregationOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.DedupeOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.EvalOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.FilterOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.LimitOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.ProjectOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.RareTopNOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.RemoveOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.RenameOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.SortOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.ValuesOperator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.WindowOperator;
import com.amazon.opendistroforelasticsearch.sql.storage.TableScanOperator;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class Explain
extends PhysicalPlanNodeVisitor<ExecutionEngine.ExplainResponseNode, Object>
implements Function<PhysicalPlan, ExecutionEngine.ExplainResponse> {
    @Override
    public ExecutionEngine.ExplainResponse apply(PhysicalPlan plan) {
        return new ExecutionEngine.ExplainResponse(plan.accept(this, null));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitProject(ProjectOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"fields", (Object)node.getProjectList().toString())));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitFilter(FilterOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"conditions", (Object)node.getConditions().toString())));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitSort(SortOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"sortList", this.describeSortList(node.getSortList()))));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitTableScan(TableScanOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"request", (Object)node.toString())));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitAggregation(AggregationOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"aggregators", (Object)node.getAggregatorList().toString(), (Object)"groupBy", (Object)node.getGroupByExprList().toString())));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitWindow(WindowOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"function", (Object)node.getWindowFunction().toString(), (Object)"definition", (Object)ImmutableMap.of((Object)"partitionBy", (Object)node.getWindowDefinition().getPartitionByList().toString(), (Object)"sortList", this.describeSortList(node.getWindowDefinition().getSortList())))));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitRename(RenameOperator node, Object context) {
        Map<String, String> renameMappingDescription = node.getMapping().entrySet().stream().collect(Collectors.toMap(e -> ((ReferenceExpression)e.getKey()).toString(), e -> ((ReferenceExpression)e.getValue()).toString()));
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"mapping", (Object)renameMappingDescription)));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitRemove(RemoveOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"removeList", (Object)node.getRemoveList().toString())));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitEval(EvalOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"expressions", this.convertPairListToMap(node.getExpressionList()))));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitDedupe(DedupeOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"dedupeList", (Object)node.getDedupeList().toString(), (Object)"allowedDuplication", (Object)node.getAllowedDuplication(), (Object)"keepEmpty", (Object)node.getKeepEmpty(), (Object)"consecutive", (Object)node.getConsecutive())));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitRareTopN(RareTopNOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"commandType", (Object)((Object)node.getCommandType()), (Object)"noOfResults", (Object)node.getNoOfResults(), (Object)"fields", (Object)node.getFieldExprList().toString(), (Object)"groupBy", (Object)node.getGroupByExprList().toString())));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitValues(ValuesOperator node, Object context) {
        return this.explain(node, context, explainNode -> explainNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"values", node.getValues())));
    }

    @Override
    public ExecutionEngine.ExplainResponseNode visitLimit(LimitOperator node, Object context) {
        return this.explain(node, context, explanNode -> explanNode.setDescription((Map<String, Object>)ImmutableMap.of((Object)"limit", (Object)node.getLimit(), (Object)"offset", (Object)node.getOffset())));
    }

    protected ExecutionEngine.ExplainResponseNode explain(PhysicalPlan node, Object context, Consumer<ExecutionEngine.ExplainResponseNode> doExplain) {
        ExecutionEngine.ExplainResponseNode explainNode = new ExecutionEngine.ExplainResponseNode(this.getOperatorName(node));
        ArrayList<ExecutionEngine.ExplainResponseNode> children = new ArrayList<ExecutionEngine.ExplainResponseNode>();
        for (PhysicalPlan child : node.getChild()) {
            children.add(child.accept(this, context));
        }
        explainNode.setChildren(children);
        doExplain.accept(explainNode);
        return explainNode;
    }

    private String getOperatorName(PhysicalPlan node) {
        return node.getClass().getSimpleName();
    }

    private <T, U> Map<String, String> convertPairListToMap(List<Pair<T, U>> pairs) {
        return pairs.stream().collect(Collectors.toMap(p -> p.getLeft().toString(), p -> p.getRight().toString()));
    }

    private Map<String, Map<String, String>> describeSortList(List<Pair<Sort.SortOption, Expression>> sortList) {
        return sortList.stream().collect(Collectors.toMap(p -> ((Expression)p.getRight()).toString(), p -> ImmutableMap.of((Object)"sortOrder", (Object)((Sort.SortOption)p.getLeft()).getSortOrder().toString(), (Object)"nullOrder", (Object)((Sort.SortOption)p.getLeft()).getNullOrder().toString())));
    }
}

