/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.type;

import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.exception.ExpressionEvaluationException;
import lombok.Generated;

public final class WideningTypeRule {
    public static final int IMPOSSIBLE_WIDENING = Integer.MAX_VALUE;
    public static final int TYPE_EQUAL = 0;

    public static int distance(ExprType type1, ExprType type2) {
        return WideningTypeRule.distance(type1, type2, 0);
    }

    private static int distance(ExprType type1, ExprType type2, int distance) {
        if (type1 == type2) {
            return distance;
        }
        if (type1 == ExprCoreType.UNKNOWN) {
            return Integer.MAX_VALUE;
        }
        return type1.getParent().stream().map(parentOfType1 -> WideningTypeRule.distance(parentOfType1, type2, distance + 1)).reduce(Math::min).get();
    }

    public static ExprType max(ExprType type1, ExprType type2) {
        int type1To2 = WideningTypeRule.distance(type1, type2);
        int type2To1 = WideningTypeRule.distance(type2, type1);
        if (type1To2 == Integer.MAX_VALUE && type2To1 == Integer.MAX_VALUE) {
            throw new ExpressionEvaluationException(String.format("no max type of %s and %s ", type1, type2));
        }
        return type1To2 == Integer.MAX_VALUE ? type1 : type2;
    }

    @Generated
    private WideningTypeRule() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

