/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.type;

import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum ExprCoreType implements ExprType
{
    UNKNOWN(new ExprCoreType[0]),
    UNDEFINED(new ExprCoreType[0]),
    BYTE(UNDEFINED),
    SHORT(BYTE),
    INTEGER(SHORT),
    LONG(INTEGER),
    FLOAT(LONG),
    DOUBLE(FLOAT),
    BOOLEAN(UNDEFINED),
    STRING(UNDEFINED),
    TIMESTAMP(UNDEFINED),
    DATE(UNDEFINED),
    TIME(UNDEFINED),
    DATETIME(UNDEFINED),
    INTERVAL(UNDEFINED),
    STRUCT(UNDEFINED),
    ARRAY(UNDEFINED);

    private final List<ExprType> parents = new ArrayList<ExprType>();
    private static final Map<ExprCoreType, String> LEGACY_TYPE_NAME_MAPPING;

    private ExprCoreType(ExprCoreType ... compatibleTypes) {
        for (ExprCoreType subType : compatibleTypes) {
            subType.parents.add(this);
        }
    }

    @Override
    public List<ExprType> getParent() {
        return this.parents.isEmpty() ? ExprType.super.getParent() : this.parents;
    }

    @Override
    public String typeName() {
        return this.name();
    }

    @Override
    public String legacyTypeName() {
        return LEGACY_TYPE_NAME_MAPPING.getOrDefault(this, this.name());
    }

    public static List<ExprCoreType> coreTypes() {
        return Arrays.stream(ExprCoreType.values()).filter(type -> type != UNKNOWN).filter(type -> type != UNDEFINED).collect(Collectors.toList());
    }

    public static List<ExprType> numberTypes() {
        return ImmutableList.of((Object)INTEGER, (Object)LONG, (Object)FLOAT, (Object)DOUBLE);
    }

    static {
        LEGACY_TYPE_NAME_MAPPING = new ImmutableMap.Builder().put((Object)STRUCT, (Object)"object").put((Object)ARRAY, (Object)"nested").put((Object)STRING, (Object)"keyword").build();
    }
}

