/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.model;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprBooleanValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprByteValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprCollectionValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprDateValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprDatetimeValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprDoubleValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprFloatValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprIntegerValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprIntervalValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprLongValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprMissingValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprNullValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprShortValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprStringValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTimeValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTimestampValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTupleValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.exception.ExpressionEvaluationException;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class ExprValueUtils {
    public static final ExprValue LITERAL_TRUE = ExprBooleanValue.of(true);
    public static final ExprValue LITERAL_FALSE = ExprBooleanValue.of(false);
    public static final ExprValue LITERAL_NULL = ExprNullValue.of();
    public static final ExprValue LITERAL_MISSING = ExprMissingValue.of();

    public static ExprValue booleanValue(Boolean value) {
        return value != false ? LITERAL_TRUE : LITERAL_FALSE;
    }

    public static ExprValue byteValue(Byte value) {
        return new ExprByteValue(value);
    }

    public static ExprValue shortValue(Short value) {
        return new ExprShortValue(value);
    }

    public static ExprValue integerValue(Integer value) {
        return new ExprIntegerValue(value);
    }

    public static ExprValue doubleValue(Double value) {
        return new ExprDoubleValue(value);
    }

    public static ExprValue floatValue(Float value) {
        return new ExprFloatValue(value);
    }

    public static ExprValue longValue(Long value) {
        return new ExprLongValue(value);
    }

    public static ExprValue stringValue(String value) {
        return new ExprStringValue(value);
    }

    public static ExprValue intervalValue(TemporalAmount value) {
        return new ExprIntervalValue(value);
    }

    public static ExprValue tupleValue(Map<String, Object> map) {
        LinkedHashMap<String, ExprValue> valueMap = new LinkedHashMap<String, ExprValue>();
        map.forEach((k, v) -> valueMap.put((String)k, ExprValueUtils.fromObjectValue(v)));
        return new ExprTupleValue(valueMap);
    }

    public static ExprValue collectionValue(List<Object> list) {
        ArrayList<ExprValue> valueList = new ArrayList<ExprValue>();
        list.forEach(o -> valueList.add(ExprValueUtils.fromObjectValue(o)));
        return new ExprCollectionValue(valueList);
    }

    public static ExprValue missingValue() {
        return ExprMissingValue.of();
    }

    public static ExprValue nullValue() {
        return ExprNullValue.of();
    }

    public static ExprValue fromObjectValue(Object o) {
        if (null == o) {
            return LITERAL_NULL;
        }
        if (o instanceof Map) {
            return ExprValueUtils.tupleValue((Map)o);
        }
        if (o instanceof List) {
            return ExprValueUtils.collectionValue((List)o);
        }
        if (o instanceof Byte) {
            return ExprValueUtils.byteValue((Byte)o);
        }
        if (o instanceof Short) {
            return ExprValueUtils.shortValue((Short)o);
        }
        if (o instanceof Integer) {
            return ExprValueUtils.integerValue((Integer)o);
        }
        if (o instanceof Long) {
            return ExprValueUtils.longValue((Long)o);
        }
        if (o instanceof Boolean) {
            return ExprValueUtils.booleanValue((Boolean)o);
        }
        if (o instanceof Double) {
            return ExprValueUtils.doubleValue((Double)o);
        }
        if (o instanceof String) {
            return ExprValueUtils.stringValue((String)o);
        }
        if (o instanceof Float) {
            return ExprValueUtils.floatValue((Float)o);
        }
        throw new ExpressionEvaluationException("unsupported object " + o.getClass());
    }

    public static ExprValue fromObjectValue(Object o, ExprCoreType type) {
        switch (type) {
            case TIMESTAMP: {
                return new ExprTimestampValue((String)o);
            }
            case DATE: {
                return new ExprDateValue((String)o);
            }
            case TIME: {
                return new ExprTimeValue((String)o);
            }
            case DATETIME: {
                return new ExprDatetimeValue((String)o);
            }
        }
        return ExprValueUtils.fromObjectValue(o);
    }

    public static Integer getIntegerValue(ExprValue exprValue) {
        return exprValue.integerValue();
    }

    public static Double getDoubleValue(ExprValue exprValue) {
        return exprValue.doubleValue();
    }

    public static Long getLongValue(ExprValue exprValue) {
        return exprValue.longValue();
    }

    public static Float getFloatValue(ExprValue exprValue) {
        return exprValue.floatValue();
    }

    public static String getStringValue(ExprValue exprValue) {
        return exprValue.stringValue();
    }

    public static List<ExprValue> getCollectionValue(ExprValue exprValue) {
        return exprValue.collectionValue();
    }

    public static Map<String, ExprValue> getTupleValue(ExprValue exprValue) {
        return exprValue.tupleValue();
    }

    public static Boolean getBooleanValue(ExprValue exprValue) {
        return exprValue.booleanValue();
    }

    @Generated
    private ExprValueUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

