/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.model;

import com.amazon.opendistroforelasticsearch.sql.data.model.AbstractExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.exception.SemanticCheckException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import lombok.Generated;

public class ExprTimestampValue
extends AbstractExprValue {
    private static final ZoneId ZONE = ZoneId.of("UTC");
    private static final DateTimeFormatter FORMATTER_WITNOUT_NANO = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final Instant timestamp;
    private static final DateTimeFormatter FORMATTER_VARIABLE_MICROS = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter();
    private static final int MIN_FRACTION_SECONDS = 0;
    private static final int MAX_FRACTION_SECONDS = 6;

    public ExprTimestampValue(String timestamp) {
        try {
            this.timestamp = LocalDateTime.parse(timestamp, FORMATTER_VARIABLE_MICROS).atZone(ZONE).toInstant();
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("timestamp:%s in unsupported format, please use yyyy-MM-dd HH:mm:ss[.SSSSSS]", timestamp));
        }
    }

    @Override
    public String value() {
        return this.timestamp.getNano() == 0 ? FORMATTER_WITNOUT_NANO.withZone(ZONE).format(this.timestamp.truncatedTo(ChronoUnit.SECONDS)) : FORMATTER_VARIABLE_MICROS.withZone(ZONE).format(this.timestamp);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.TIMESTAMP;
    }

    @Override
    public Instant timestampValue() {
        return this.timestamp;
    }

    @Override
    public LocalDate dateValue() {
        return this.timestamp.atZone(ZONE).toLocalDate();
    }

    @Override
    public LocalTime timeValue() {
        return this.timestamp.atZone(ZONE).toLocalTime();
    }

    @Override
    public LocalDateTime datetimeValue() {
        return this.timestamp.atZone(ZONE).toLocalDateTime();
    }

    public String toString() {
        return String.format("TIMESTAMP '%s'", this.value());
    }

    @Override
    public int compare(ExprValue other) {
        return this.timestamp.compareTo(other.timestampValue().atZone(ZONE).toInstant());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.timestamp.equals(other.timestampValue().atZone(ZONE).toInstant());
    }

    public int hashCode() {
        return Objects.hashCode(this.timestamp);
    }

    @Generated
    public ExprTimestampValue(Instant timestamp) {
        this.timestamp = timestamp;
    }
}

