/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.model;

import com.amazon.opendistroforelasticsearch.sql.data.model.AbstractExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.exception.SemanticCheckException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Objects;
import lombok.Generated;

public class ExprTimeValue
extends AbstractExprValue {
    private final LocalTime time;
    private static final DateTimeFormatter FORMATTER_VARIABLE_MICROS = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter();
    private static final int MIN_FRACTION_SECONDS = 0;
    private static final int MAX_FRACTION_SECONDS = 6;

    public ExprTimeValue(String time) {
        try {
            this.time = LocalTime.parse(time, FORMATTER_VARIABLE_MICROS);
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("time:%s in unsupported format, please use HH:mm:ss[.SSSSSS]", time));
        }
    }

    @Override
    public String value() {
        return DateTimeFormatter.ISO_LOCAL_TIME.format(this.time);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.TIME;
    }

    @Override
    public LocalTime timeValue() {
        return this.time;
    }

    public String toString() {
        return String.format("TIME '%s'", this.value());
    }

    @Override
    public int compare(ExprValue other) {
        return this.time.compareTo(other.timeValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.time.equals(other.timeValue());
    }

    public int hashCode() {
        return Objects.hashCode(this.time);
    }

    @Generated
    public ExprTimeValue(LocalTime time) {
        this.time = time;
    }
}

