/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.model;

import com.amazon.opendistroforelasticsearch.sql.data.model.AbstractExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprDateValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprDatetimeValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTimeValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.exception.SemanticCheckException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import lombok.Generated;

public class ExprStringValue
extends AbstractExprValue {
    private final String value;

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.STRING;
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public LocalDateTime datetimeValue() {
        try {
            return new ExprDatetimeValue(this.value).datetimeValue();
        }
        catch (SemanticCheckException e) {
            try {
                return new ExprDatetimeValue(LocalDateTime.of(new ExprDateValue(this.value).dateValue(), LocalTime.of(0, 0, 0))).datetimeValue();
            }
            catch (SemanticCheckException exception) {
                throw new SemanticCheckException(String.format("datetime:%s in unsupported format, please use yyyy-MM-dd HH:mm:ss[.SSSSSS]", this.value));
            }
        }
    }

    @Override
    public LocalDate dateValue() {
        try {
            return new ExprDatetimeValue(this.value).dateValue();
        }
        catch (SemanticCheckException e) {
            return new ExprDateValue(this.value).dateValue();
        }
    }

    @Override
    public LocalTime timeValue() {
        try {
            return new ExprDatetimeValue(this.value).timeValue();
        }
        catch (SemanticCheckException e) {
            return new ExprTimeValue(this.value).timeValue();
        }
    }

    public String toString() {
        return String.format("\"%s\"", this.value);
    }

    @Override
    public int compare(ExprValue other) {
        return this.value.compareTo(other.stringValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.value.equals(other.stringValue());
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Generated
    public ExprStringValue(String value) {
        this.value = value;
    }
}

