/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.model;

import com.amazon.opendistroforelasticsearch.sql.data.model.AbstractExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import java.util.Objects;

public class ExprNullValue
extends AbstractExprValue {
    private static final ExprNullValue instance = new ExprNullValue();

    private ExprNullValue() {
    }

    public int hashCode() {
        return Objects.hashCode("NULL");
    }

    public String toString() {
        return "NULL";
    }

    public static ExprNullValue of() {
        return instance;
    }

    @Override
    public Object value() {
        return null;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.UNDEFINED;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public int compare(ExprValue other) {
        throw new IllegalStateException(String.format("[BUG] Unreachable, Comparing with NULL is undefined", new Object[0]));
    }

    @Override
    public boolean equal(ExprValue other) {
        return other.isNull();
    }
}

