/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.model;

import com.amazon.opendistroforelasticsearch.sql.data.model.AbstractExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.google.common.base.Objects;

public class ExprBooleanValue
extends AbstractExprValue {
    private static final ExprBooleanValue TRUE = new ExprBooleanValue(true);
    private static final ExprBooleanValue FALSE = new ExprBooleanValue(false);
    private final Boolean value;

    private ExprBooleanValue(Boolean value) {
        this.value = value;
    }

    public static ExprBooleanValue of(Boolean value) {
        return value != false ? TRUE : FALSE;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.BOOLEAN;
    }

    @Override
    public Boolean booleanValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int compare(ExprValue other) {
        return Boolean.compare(this.value, other.booleanValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.value.equals(other.booleanValue());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }
}

