/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.data.model;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.exception.ExpressionEvaluationException;

public abstract class AbstractExprValue
implements ExprValue {
    @Override
    public int compareTo(ExprValue other) {
        if (this.isNull() || this.isMissing() || other.isNull() || other.isMissing()) {
            throw new IllegalStateException(String.format("[BUG] Unreachable, Comparing with NULL or MISSING is undefined", new Object[0]));
        }
        if (this.isNumber() && other.isNumber() || this.type() == other.type()) {
            return this.compare(other);
        }
        throw new ExpressionEvaluationException(String.format("compare expected value have same type, but with [%s, %s]", this.type(), other.type()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprValue)) {
            return false;
        }
        ExprValue other = (ExprValue)o;
        if (this.isNull() || this.isMissing()) {
            return this.equal(other);
        }
        if (other.isNull() || other.isMissing()) {
            return other.equals(this);
        }
        return this.equal(other);
    }

    public abstract int compare(ExprValue var1);

    public abstract boolean equal(ExprValue var1);
}

