/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.ast.expression;

import com.amazon.opendistroforelasticsearch.sql.ast.AbstractNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.ast.Node;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;

public class Cast
extends UnresolvedExpression {
    private static Map<String, FunctionName> CONVERTED_TYPE_FUNCTION_NAME_MAP = new ImmutableMap.Builder().put((Object)"string", (Object)BuiltinFunctionName.CAST_TO_STRING.getName()).put((Object)"int", (Object)BuiltinFunctionName.CAST_TO_INT.getName()).put((Object)"long", (Object)BuiltinFunctionName.CAST_TO_LONG.getName()).put((Object)"float", (Object)BuiltinFunctionName.CAST_TO_FLOAT.getName()).put((Object)"double", (Object)BuiltinFunctionName.CAST_TO_DOUBLE.getName()).put((Object)"boolean", (Object)BuiltinFunctionName.CAST_TO_BOOLEAN.getName()).put((Object)"date", (Object)BuiltinFunctionName.CAST_TO_DATE.getName()).put((Object)"time", (Object)BuiltinFunctionName.CAST_TO_TIME.getName()).put((Object)"timestamp", (Object)BuiltinFunctionName.CAST_TO_TIMESTAMP.getName()).build();
    private final UnresolvedExpression expression;
    private final UnresolvedExpression convertedType;

    public FunctionName convertFunctionName() {
        String type = this.convertedType.toString().toLowerCase(Locale.ROOT);
        if (CONVERTED_TYPE_FUNCTION_NAME_MAP.containsKey(type)) {
            return CONVERTED_TYPE_FUNCTION_NAME_MAP.get(type);
        }
        throw new IllegalStateException("unsupported cast type: " + type);
    }

    @Override
    public List<? extends Node> getChild() {
        return Collections.singletonList(this.expression);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitCast(this, context);
    }

    @Generated
    public Cast(UnresolvedExpression expression, UnresolvedExpression convertedType) {
        this.expression = expression;
        this.convertedType = convertedType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cast)) {
            return false;
        }
        Cast other = (Cast)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnresolvedExpression this$expression = this.getExpression();
        UnresolvedExpression other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !((Object)this$expression).equals(other$expression)) {
            return false;
        }
        UnresolvedExpression this$convertedType = this.getConvertedType();
        UnresolvedExpression other$convertedType = other.getConvertedType();
        return !(this$convertedType == null ? other$convertedType != null : !((Object)this$convertedType).equals(other$convertedType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cast;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnresolvedExpression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : ((Object)$expression).hashCode());
        UnresolvedExpression $convertedType = this.getConvertedType();
        result = result * 59 + ($convertedType == null ? 43 : ((Object)$convertedType).hashCode());
        return result;
    }

    @Generated
    public UnresolvedExpression getExpression() {
        return this.expression;
    }

    @Generated
    public UnresolvedExpression getConvertedType() {
        return this.convertedType;
    }

    @Override
    @Generated
    public String toString() {
        return "Cast(expression=" + this.getExpression() + ", convertedType=" + this.getConvertedType() + ")";
    }
}

