/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.analysis;

import com.amazon.opendistroforelasticsearch.sql.analysis.AnalysisContext;
import com.amazon.opendistroforelasticsearch.sql.analysis.ExpressionAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.ast.AbstractNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Alias;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.WindowFunction;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Sort;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.NamedExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.window.WindowDefinition;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalSort;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalWindow;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class WindowExpressionAnalyzer
extends AbstractNodeVisitor<LogicalPlan, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;
    private final LogicalPlan child;

    public LogicalPlan analyze(UnresolvedExpression projectItem, AnalysisContext context) {
        LogicalPlan window = projectItem.accept(this, context);
        return window == null ? this.child : window;
    }

    @Override
    public LogicalPlan visitAlias(Alias node, AnalysisContext context) {
        if (!(node.getDelegated() instanceof WindowFunction)) {
            return null;
        }
        WindowFunction unresolved = (WindowFunction)node.getDelegated();
        Expression windowFunction = this.expressionAnalyzer.analyze(unresolved, context);
        List<Expression> partitionByList = this.analyzePartitionList(unresolved, context);
        List<Pair<Sort.SortOption, Expression>> sortList = this.analyzeSortList(unresolved, context);
        WindowDefinition windowDefinition = new WindowDefinition(partitionByList, sortList);
        NamedExpression namedWindowFunction = new NamedExpression(node.getName(), windowFunction, node.getAlias());
        List<Pair<Sort.SortOption, Expression>> allSortItems = windowDefinition.getAllSortItems();
        if (allSortItems.isEmpty()) {
            return new LogicalWindow(this.child, namedWindowFunction, windowDefinition);
        }
        return new LogicalWindow(new LogicalSort(this.child, allSortItems), namedWindowFunction, windowDefinition);
    }

    private List<Expression> analyzePartitionList(WindowFunction node, AnalysisContext context) {
        return node.getPartitionByList().stream().map(expr -> this.expressionAnalyzer.analyze((UnresolvedExpression)expr, context)).collect(Collectors.toList());
    }

    private List<Pair<Sort.SortOption, Expression>> analyzeSortList(WindowFunction node, AnalysisContext context) {
        return node.getSortList().stream().map(pair -> ImmutablePair.of((Object)this.analyzeSortOption((Sort.SortOption)pair.getLeft()), (Object)this.expressionAnalyzer.analyze((UnresolvedExpression)pair.getRight(), context))).collect(Collectors.toList());
    }

    private Sort.SortOption analyzeSortOption(Sort.SortOption option) {
        if (option.getNullOrder() == null) {
            return option.getSortOrder() == Sort.SortOrder.DESC ? Sort.SortOption.DEFAULT_DESC : Sort.SortOption.DEFAULT_ASC;
        }
        return new Sort.SortOption(option.getSortOrder() == Sort.SortOrder.DESC ? Sort.SortOrder.DESC : Sort.SortOrder.ASC, option.getNullOrder());
    }

    @Generated
    public WindowExpressionAnalyzer(ExpressionAnalyzer expressionAnalyzer, LogicalPlan child) {
        this.expressionAnalyzer = expressionAnalyzer;
        this.child = child;
    }
}

