/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.analysis;

import com.amazon.opendistroforelasticsearch.sql.analysis.AnalysisContext;
import com.amazon.opendistroforelasticsearch.sql.analysis.ExpressionAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.analysis.ExpressionReferenceOptimizer;
import com.amazon.opendistroforelasticsearch.sql.analysis.QualifierAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.analysis.TypeEnvironment;
import com.amazon.opendistroforelasticsearch.sql.analysis.symbol.Namespace;
import com.amazon.opendistroforelasticsearch.sql.ast.AbstractNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Alias;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.AllFields;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Field;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.QualifiedName;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.expression.DSL;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.NamedExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.ReferenceExpression;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class SelectExpressionAnalyzer
extends AbstractNodeVisitor<List<NamedExpression>, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;
    private ExpressionReferenceOptimizer optimizer;

    public List<NamedExpression> analyze(List<UnresolvedExpression> selectList, AnalysisContext analysisContext, ExpressionReferenceOptimizer optimizer) {
        this.optimizer = optimizer;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (UnresolvedExpression unresolvedExpression : selectList) {
            builder.addAll((Iterable)unresolvedExpression.accept(this, analysisContext));
        }
        return builder.build();
    }

    @Override
    public List<NamedExpression> visitField(Field node, AnalysisContext context) {
        return Collections.singletonList(DSL.named(node.accept(this.expressionAnalyzer, context)));
    }

    @Override
    public List<NamedExpression> visitAlias(Alias node, AnalysisContext context) {
        Expression expr = this.referenceIfSymbolDefined(node, context);
        return Collections.singletonList(DSL.named(this.unqualifiedNameIfFieldOnly(node, context), expr, node.getAlias()));
    }

    private Expression referenceIfSymbolDefined(Alias expr, AnalysisContext context) {
        UnresolvedExpression delegatedExpr = expr.getDelegated();
        return this.optimizer.optimize(DSL.named(expr.getName(), delegatedExpr.accept(this.expressionAnalyzer, context), expr.getAlias()), context);
    }

    @Override
    public List<NamedExpression> visitAllFields(AllFields node, AnalysisContext context) {
        TypeEnvironment environment = context.peek();
        Map<String, ExprType> lookupAllFields = environment.lookupAllFields(Namespace.FIELD_NAME);
        return lookupAllFields.entrySet().stream().map(entry -> DSL.named((String)entry.getKey(), new ReferenceExpression((String)entry.getKey(), (ExprType)entry.getValue()))).collect(Collectors.toList());
    }

    private String unqualifiedNameIfFieldOnly(Alias node, AnalysisContext context) {
        UnresolvedExpression selectItem = node.getDelegated();
        if (selectItem instanceof QualifiedName) {
            QualifierAnalyzer qualifierAnalyzer = new QualifierAnalyzer(context);
            return qualifierAnalyzer.unqualified((QualifiedName)selectItem);
        }
        return node.getName();
    }

    @Generated
    public SelectExpressionAnalyzer(ExpressionAnalyzer expressionAnalyzer) {
        this.expressionAnalyzer = expressionAnalyzer;
    }
}

