/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.analysis;

import com.amazon.opendistroforelasticsearch.sql.analysis.AnalysisContext;
import com.amazon.opendistroforelasticsearch.sql.analysis.symbol.Namespace;
import com.amazon.opendistroforelasticsearch.sql.analysis.symbol.Symbol;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.QualifiedName;
import com.amazon.opendistroforelasticsearch.sql.common.antlr.SyntaxCheckException;
import com.amazon.opendistroforelasticsearch.sql.exception.SemanticCheckException;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public class QualifierAnalyzer {
    private final AnalysisContext context;

    public String unqualified(String ... parts) {
        return this.unqualified(QualifiedName.of(Arrays.asList(parts)));
    }

    public String unqualified(QualifiedName fullName) {
        return this.isQualifierIndexOrAlias(fullName) ? fullName.rest().toString() : fullName.toString();
    }

    private boolean isQualifierIndexOrAlias(QualifiedName fullName) {
        Optional<String> qualifier = fullName.first();
        if (qualifier.isPresent()) {
            if (this.isFieldName(qualifier.get())) {
                return false;
            }
            this.resolveQualifierSymbol(fullName, qualifier.get());
            return true;
        }
        return false;
    }

    private boolean isFieldName(String qualifier) {
        try {
            this.context.peek().resolve(new Symbol(Namespace.FIELD_NAME, qualifier));
            return true;
        }
        catch (SemanticCheckException e2) {
            return false;
        }
    }

    private void resolveQualifierSymbol(QualifiedName fullName, String qualifier) {
        try {
            this.context.peek().resolve(new Symbol(Namespace.INDEX_NAME, qualifier));
        }
        catch (SemanticCheckException e) {
            throw new SyntaxCheckException(String.format("The qualifier [%s] of qualified name [%s] must be an field name, index name or its alias", qualifier, fullName));
        }
    }

    @Generated
    public QualifierAnalyzer(AnalysisContext context) {
        this.context = context;
    }
}

