/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.analysis;

import com.amazon.opendistroforelasticsearch.sql.analysis.AnalysisContext;
import com.amazon.opendistroforelasticsearch.sql.analysis.ExpressionAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.analysis.QualifierAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.ast.AbstractNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Alias;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.QualifiedName;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.DSL;
import com.amazon.opendistroforelasticsearch.sql.expression.NamedExpression;
import lombok.Generated;

public class NamedExpressionAnalyzer
extends AbstractNodeVisitor<NamedExpression, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;

    public NamedExpression analyze(UnresolvedExpression expression, AnalysisContext analysisContext) {
        return expression.accept(this, analysisContext);
    }

    @Override
    public NamedExpression visitAlias(Alias node, AnalysisContext context) {
        return DSL.named(this.unqualifiedNameIfFieldOnly(node, context), node.getDelegated().accept(this.expressionAnalyzer, context), node.getAlias());
    }

    private String unqualifiedNameIfFieldOnly(Alias node, AnalysisContext context) {
        UnresolvedExpression selectItem = node.getDelegated();
        if (selectItem instanceof QualifiedName) {
            QualifierAnalyzer qualifierAnalyzer = new QualifierAnalyzer(context);
            return qualifierAnalyzer.unqualified((QualifiedName)selectItem);
        }
        return node.getName();
    }

    @Generated
    public NamedExpressionAnalyzer(ExpressionAnalyzer expressionAnalyzer) {
        this.expressionAnalyzer = expressionAnalyzer;
    }
}

