/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.analysis;

import com.amazon.opendistroforelasticsearch.sql.analysis.AnalysisContext;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.ExpressionNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.expression.FunctionExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.NamedExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.ReferenceExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.conditional.cases.CaseClause;
import com.amazon.opendistroforelasticsearch.sql.expression.conditional.cases.WhenClause;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionRepository;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalAggregation;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalPlanNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalWindow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExpressionReferenceOptimizer
extends ExpressionNodeVisitor<Expression, AnalysisContext> {
    private final BuiltinFunctionRepository repository;
    private final Map<Expression, Expression> expressionMap = new HashMap<Expression, Expression>();

    public ExpressionReferenceOptimizer(BuiltinFunctionRepository repository, LogicalPlan logicalPlan) {
        this.repository = repository;
        logicalPlan.accept(new ExpressionMapBuilder(), null);
    }

    public Expression optimize(Expression analyzed, AnalysisContext context) {
        return analyzed.accept(this, context);
    }

    @Override
    public Expression visitNode(Expression node, AnalysisContext context) {
        return node;
    }

    @Override
    public Expression visitFunction(FunctionExpression node, AnalysisContext context) {
        if (this.expressionMap.containsKey(node)) {
            return this.expressionMap.get(node);
        }
        List<Expression> args = node.getArguments().stream().map(expr -> expr.accept(this, context)).collect(Collectors.toList());
        return (Expression)((Object)this.repository.compile(node.getFunctionName(), args));
    }

    @Override
    public Expression visitAggregator(Aggregator<?> node, AnalysisContext context) {
        return this.expressionMap.getOrDefault(node, node);
    }

    @Override
    public Expression visitNamed(NamedExpression node, AnalysisContext context) {
        if (this.expressionMap.containsKey(node)) {
            return this.expressionMap.get(node);
        }
        return node.getDelegated().accept(this, context);
    }

    @Override
    public Expression visitCase(CaseClause node, AnalysisContext context) {
        if (this.expressionMap.containsKey(node)) {
            return this.expressionMap.get(node);
        }
        List<WhenClause> whenClauses = node.getWhenClauses().stream().map(expr -> (WhenClause)expr.accept(this, context)).collect(Collectors.toList());
        Expression defaultResult = null;
        if (node.getDefaultResult() != null) {
            defaultResult = node.getDefaultResult().accept(this, context);
        }
        return new CaseClause(whenClauses, defaultResult);
    }

    @Override
    public Expression visitWhen(WhenClause node, AnalysisContext context) {
        return new WhenClause(node.getCondition().accept(this, context), node.getResult().accept(this, context));
    }

    class ExpressionMapBuilder
    extends LogicalPlanNodeVisitor<Void, Void> {
        ExpressionMapBuilder() {
        }

        @Override
        public Void visitNode(LogicalPlan plan, Void context) {
            plan.getChild().forEach(child -> child.accept(this, context));
            return null;
        }

        @Override
        public Void visitAggregation(LogicalAggregation plan, Void context) {
            plan.getAggregatorList().forEach(namedAggregator -> ExpressionReferenceOptimizer.this.expressionMap.put(namedAggregator.getDelegated(), new ReferenceExpression(namedAggregator.getName(), namedAggregator.type())));
            plan.getGroupByList().forEach(groupBy -> ExpressionReferenceOptimizer.this.expressionMap.put(groupBy.getDelegated(), new ReferenceExpression(groupBy.getNameOrAlias(), groupBy.type())));
            return null;
        }

        @Override
        public Void visitWindow(LogicalWindow plan, Void context) {
            NamedExpression windowFunc = plan.getWindowFunction();
            ExpressionReferenceOptimizer.this.expressionMap.put(windowFunc, new ReferenceExpression(windowFunc.getName(), windowFunc.type()));
            return this.visitNode((LogicalPlan)plan, context);
        }
    }
}

