/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.analysis;

import com.amazon.opendistroforelasticsearch.sql.analysis.AnalysisContext;
import com.amazon.opendistroforelasticsearch.sql.analysis.QualifierAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.analysis.TypeEnvironment;
import com.amazon.opendistroforelasticsearch.sql.analysis.symbol.Namespace;
import com.amazon.opendistroforelasticsearch.sql.analysis.symbol.Symbol;
import com.amazon.opendistroforelasticsearch.sql.ast.AbstractNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.AggregateFunction;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.AllFields;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.And;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Case;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Cast;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Compare;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.EqualTo;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Field;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Function;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Interval;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Literal;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Not;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Or;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.QualifiedName;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedAttribute;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.When;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.WindowFunction;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Xor;
import com.amazon.opendistroforelasticsearch.sql.common.antlr.SyntaxCheckException;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValueUtils;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.exception.SemanticCheckException;
import com.amazon.opendistroforelasticsearch.sql.expression.DSL;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.LiteralExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.ReferenceExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.conditional.cases.CaseClause;
import com.amazon.opendistroforelasticsearch.sql.expression.conditional.cases.WhenClause;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionRepository;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.window.aggregation.AggregateWindowFunction;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class ExpressionAnalyzer
extends AbstractNodeVisitor<Expression, AnalysisContext> {
    private final BuiltinFunctionRepository repository;
    private final DSL dsl;

    @Override
    public Expression visitCast(Cast node, AnalysisContext context) {
        Expression expression = node.getExpression().accept(this, context);
        return (Expression)((Object)this.repository.compile(node.convertFunctionName(), Collections.singletonList(expression)));
    }

    public ExpressionAnalyzer(BuiltinFunctionRepository repository) {
        this.repository = repository;
        this.dsl = new DSL(repository);
    }

    public Expression analyze(UnresolvedExpression unresolved, AnalysisContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public Expression visitUnresolvedAttribute(UnresolvedAttribute node, AnalysisContext context) {
        return this.visitIdentifier(node.getAttr(), context);
    }

    @Override
    public Expression visitEqualTo(EqualTo node, AnalysisContext context) {
        Expression left = node.getLeft().accept(this, context);
        Expression right = node.getRight().accept(this, context);
        return this.dsl.equal(left, right);
    }

    @Override
    public Expression visitLiteral(Literal node, AnalysisContext context) {
        return DSL.literal(ExprValueUtils.fromObjectValue(node.getValue(), node.getType().getCoreType()));
    }

    @Override
    public Expression visitInterval(Interval node, AnalysisContext context) {
        Expression value = node.getValue().accept(this, context);
        LiteralExpression unit = DSL.literal(node.getUnit().name());
        return this.dsl.interval(value, unit);
    }

    @Override
    public Expression visitAnd(And node, AnalysisContext context) {
        Expression left = node.getLeft().accept(this, context);
        Expression right = node.getRight().accept(this, context);
        return this.dsl.and(left, right);
    }

    @Override
    public Expression visitOr(Or node, AnalysisContext context) {
        Expression left = node.getLeft().accept(this, context);
        Expression right = node.getRight().accept(this, context);
        return this.dsl.or(left, right);
    }

    @Override
    public Expression visitXor(Xor node, AnalysisContext context) {
        Expression left = node.getLeft().accept(this, context);
        Expression right = node.getRight().accept(this, context);
        return this.dsl.xor(left, right);
    }

    @Override
    public Expression visitNot(Not node, AnalysisContext context) {
        return this.dsl.not(node.getExpression().accept(this, context));
    }

    @Override
    public Expression visitAggregateFunction(AggregateFunction node, AnalysisContext context) {
        Optional<BuiltinFunctionName> builtinFunctionName = BuiltinFunctionName.of(node.getFuncName());
        if (builtinFunctionName.isPresent()) {
            Expression arg = node.getField().accept(this, context);
            Aggregator aggregator = (Aggregator)this.repository.compile(builtinFunctionName.get().getName(), Collections.singletonList(arg));
            if (node.getCondition() != null) {
                aggregator.condition(this.analyze(node.getCondition(), context));
            }
            return aggregator;
        }
        throw new SemanticCheckException("Unsupported aggregation function " + node.getFuncName());
    }

    @Override
    public Expression visitFunction(Function node, AnalysisContext context) {
        FunctionName functionName = FunctionName.of(node.getFuncName());
        List<Expression> arguments = node.getFuncArgs().stream().map(unresolvedExpression -> this.analyze((UnresolvedExpression)unresolvedExpression, context)).collect(Collectors.toList());
        return (Expression)((Object)this.repository.compile(functionName, arguments));
    }

    @Override
    public Expression visitWindowFunction(WindowFunction node, AnalysisContext context) {
        Expression expr = node.getFunction().accept(this, context);
        if (expr instanceof Aggregator) {
            return new AggregateWindowFunction((Aggregator)expr);
        }
        return expr;
    }

    @Override
    public Expression visitCompare(Compare node, AnalysisContext context) {
        FunctionName functionName = FunctionName.of(node.getOperator());
        Expression left = this.analyze(node.getLeft(), context);
        Expression right = this.analyze(node.getRight(), context);
        return (Expression)((Object)this.repository.compile(functionName, Arrays.asList(left, right)));
    }

    @Override
    public Expression visitCase(Case node, AnalysisContext context) {
        ArrayList<WhenClause> whens = new ArrayList<WhenClause>();
        for (When when : node.getWhenClauses()) {
            if (node.getCaseValue() == null) {
                whens.add((WhenClause)this.analyze(when, context));
                continue;
            }
            whens.add((WhenClause)this.analyze(new When(new Function("=", Arrays.asList(node.getCaseValue(), when.getCondition())), when.getResult()), context));
        }
        Expression defaultResult = node.getElseClause() == null ? null : this.analyze(node.getElseClause(), context);
        CaseClause caseClause = new CaseClause(whens, defaultResult);
        List<ExprType> resultTypes = caseClause.allResultTypes();
        if (ImmutableSet.copyOf(resultTypes).size() > 1) {
            throw new SemanticCheckException("All result types of CASE clause must be the same, but found " + resultTypes);
        }
        return caseClause;
    }

    @Override
    public Expression visitWhen(When node, AnalysisContext context) {
        return new WhenClause(this.analyze(node.getCondition(), context), this.analyze(node.getResult(), context));
    }

    @Override
    public Expression visitField(Field node, AnalysisContext context) {
        String attr = node.getField().toString();
        return this.visitIdentifier(attr, context);
    }

    @Override
    public Expression visitAllFields(AllFields node, AnalysisContext context) {
        return DSL.literal("*");
    }

    @Override
    public Expression visitQualifiedName(QualifiedName node, AnalysisContext context) {
        QualifierAnalyzer qualifierAnalyzer = new QualifierAnalyzer(context);
        return this.visitIdentifier(qualifierAnalyzer.unqualified(node), context);
    }

    private Expression visitIdentifier(String ident, AnalysisContext context) {
        TypeEnvironment typeEnv = context.peek();
        ReferenceExpression ref = DSL.ref(ident, typeEnv.resolve(new Symbol(Namespace.FIELD_NAME, ident)));
        if (this.isTypeNotSupported(ref.type())) {
            throw new SyntaxCheckException(String.format("Identifier [%s] of type [%s] is not supported yet", ident, ref.type()));
        }
        return ref;
    }

    private boolean isTypeNotSupported(ExprType type) {
        return "array".equalsIgnoreCase(type.typeName());
    }

    @Generated
    public BuiltinFunctionRepository getRepository() {
        return this.repository;
    }
}

