/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.analysis;

import com.amazon.opendistroforelasticsearch.sql.analysis.AnalysisContext;
import com.amazon.opendistroforelasticsearch.sql.analysis.ExpressionAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.analysis.ExpressionReferenceOptimizer;
import com.amazon.opendistroforelasticsearch.sql.analysis.NamedExpressionAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.analysis.SelectExpressionAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.analysis.TypeEnvironment;
import com.amazon.opendistroforelasticsearch.sql.analysis.WindowExpressionAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.analysis.symbol.Namespace;
import com.amazon.opendistroforelasticsearch.sql.analysis.symbol.Symbol;
import com.amazon.opendistroforelasticsearch.sql.ast.AbstractNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Argument;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Field;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Let;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Literal;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Aggregation;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Dedupe;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Eval;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Filter;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Head;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Limit;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Project;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.RareTopN;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Relation;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.RelationSubquery;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Rename;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Sort;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.UnresolvedPlan;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Values;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.exception.SemanticCheckException;
import com.amazon.opendistroforelasticsearch.sql.expression.DSL;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.LiteralExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.NamedExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.ReferenceExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.Aggregator;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.NamedAggregator;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalAggregation;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalDedupe;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalEval;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalFilter;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalLimit;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalProject;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalRareTopN;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalRelation;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalRemove;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalRename;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalSort;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalValues;
import com.amazon.opendistroforelasticsearch.sql.storage.StorageEngine;
import com.amazon.opendistroforelasticsearch.sql.storage.Table;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Analyzer
extends AbstractNodeVisitor<LogicalPlan, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;
    private final SelectExpressionAnalyzer selectExpressionAnalyzer;
    private final NamedExpressionAnalyzer namedExpressionAnalyzer;
    private final StorageEngine storageEngine;

    public Analyzer(ExpressionAnalyzer expressionAnalyzer, StorageEngine storageEngine) {
        this.expressionAnalyzer = expressionAnalyzer;
        this.storageEngine = storageEngine;
        this.selectExpressionAnalyzer = new SelectExpressionAnalyzer(expressionAnalyzer);
        this.namedExpressionAnalyzer = new NamedExpressionAnalyzer(expressionAnalyzer);
    }

    public LogicalPlan analyze(UnresolvedPlan unresolved, AnalysisContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public LogicalPlan visitRelation(Relation node, AnalysisContext context) {
        context.push();
        TypeEnvironment curEnv = context.peek();
        Table table = this.storageEngine.getTable(node.getTableName());
        table.getFieldTypes().forEach((k, v) -> curEnv.define(new Symbol(Namespace.FIELD_NAME, (String)k), (ExprType)v));
        curEnv.define(new Symbol(Namespace.INDEX_NAME, node.getTableNameOrAlias()), ExprCoreType.STRUCT);
        return new LogicalRelation(node.getTableName());
    }

    @Override
    public LogicalPlan visitRelationSubquery(RelationSubquery node, AnalysisContext context) {
        LogicalPlan subquery = this.analyze(node.getChild().get(0), context);
        TypeEnvironment curEnv = context.peek();
        curEnv.define(new Symbol(Namespace.INDEX_NAME, node.getAliasAsTableName()), ExprCoreType.STRUCT);
        return subquery;
    }

    @Override
    public LogicalPlan visitLimit(Limit node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        return new LogicalLimit(child, node.getLimit(), node.getOffset());
    }

    @Override
    public LogicalPlan visitFilter(Filter node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        Expression condition = this.expressionAnalyzer.analyze(node.getCondition(), context);
        ExpressionReferenceOptimizer optimizer = new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child);
        Expression optimized = optimizer.optimize(condition, context);
        return new LogicalFilter(child, optimized);
    }

    @Override
    public LogicalPlan visitRename(Rename node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableMap.Builder renameMapBuilder = new ImmutableMap.Builder();
        for (com.amazon.opendistroforelasticsearch.sql.ast.expression.Map renameMap : node.getRenameList()) {
            Expression origin = this.expressionAnalyzer.analyze(renameMap.getOrigin(), context);
            if (renameMap.getTarget() instanceof Field) {
                ReferenceExpression target = new ReferenceExpression(((Field)renameMap.getTarget()).getField().toString(), origin.type());
                ReferenceExpression originExpr = DSL.ref(origin.toString(), origin.type());
                TypeEnvironment curEnv = context.peek();
                curEnv.remove(originExpr);
                curEnv.define(target);
                renameMapBuilder.put((Object)originExpr, (Object)target);
                continue;
            }
            throw new SemanticCheckException(String.format("the target expected to be field, but is %s", renameMap.getTarget()));
        }
        return new LogicalRename(child, (Map<ReferenceExpression, ReferenceExpression>)renameMapBuilder.build());
    }

    @Override
    public LogicalPlan visitAggregation(Aggregation node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder aggregatorBuilder = new ImmutableList.Builder();
        for (UnresolvedExpression expr : node.getAggExprList()) {
            NamedExpression aggExpr = this.namedExpressionAnalyzer.analyze(expr, context);
            aggregatorBuilder.add((Object)new NamedAggregator(aggExpr.getNameOrAlias(), (Aggregator)aggExpr.getDelegated()));
        }
        ImmutableList aggregators = aggregatorBuilder.build();
        ImmutableList.Builder groupbyBuilder = new ImmutableList.Builder();
        for (UnresolvedExpression expr : node.getGroupExprList()) {
            groupbyBuilder.add((Object)this.namedExpressionAnalyzer.analyze(expr, context));
        }
        ImmutableList groupBys = groupbyBuilder.build();
        context.push();
        TypeEnvironment newEnv = context.peek();
        aggregators.forEach(aggregator -> newEnv.define(new Symbol(Namespace.FIELD_NAME, aggregator.getName()), aggregator.type()));
        groupBys.forEach(group -> newEnv.define(new Symbol(Namespace.FIELD_NAME, group.getNameOrAlias()), group.type()));
        return new LogicalAggregation(child, (List<NamedAggregator>)aggregators, (List<NamedExpression>)groupBys);
    }

    @Override
    public LogicalPlan visitRareTopN(RareTopN node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder groupbyBuilder = new ImmutableList.Builder();
        for (UnresolvedExpression expr : node.getGroupExprList()) {
            groupbyBuilder.add((Object)this.expressionAnalyzer.analyze(expr, context));
        }
        ImmutableList groupBys = groupbyBuilder.build();
        ImmutableList.Builder fieldsBuilder = new ImmutableList.Builder();
        for (Field f : node.getFields()) {
            fieldsBuilder.add((Object)this.expressionAnalyzer.analyze(f, context));
        }
        ImmutableList fields = fieldsBuilder.build();
        context.push();
        TypeEnvironment newEnv = context.peek();
        groupBys.forEach(group -> newEnv.define(new Symbol(Namespace.FIELD_NAME, group.toString()), group.type()));
        fields.forEach(field -> newEnv.define(new Symbol(Namespace.FIELD_NAME, field.toString()), field.type()));
        List<Argument> options = node.getNoOfResults();
        Integer noOfResults = (Integer)options.get(0).getValue().getValue();
        return new LogicalRareTopN(child, node.getCommandType(), noOfResults, (List<Expression>)fields, (List<Expression>)groupBys);
    }

    @Override
    public LogicalPlan visitProject(Project node, AnalysisContext context) {
        Object argument;
        Boolean exclude;
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        if (node.hasArgument() && (exclude = (Boolean)((Argument)(argument = node.getArgExprList().get(0))).getValue().getValue()).booleanValue()) {
            TypeEnvironment curEnv = context.peek();
            List<ReferenceExpression> referenceExpressions = node.getProjectList().stream().map(expr -> (ReferenceExpression)this.expressionAnalyzer.analyze((UnresolvedExpression)expr, context)).collect(Collectors.toList());
            referenceExpressions.forEach(ref -> curEnv.remove((ReferenceExpression)ref));
            return new LogicalRemove(child, (Set<ReferenceExpression>)ImmutableSet.copyOf(referenceExpressions));
        }
        for (UnresolvedExpression expr2 : node.getProjectList()) {
            WindowExpressionAnalyzer windowAnalyzer = new WindowExpressionAnalyzer(this.expressionAnalyzer, child);
            child = windowAnalyzer.analyze(expr2, context);
        }
        List<NamedExpression> namedExpressions = this.selectExpressionAnalyzer.analyze(node.getProjectList(), context, new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child));
        context.push();
        TypeEnvironment newEnv = context.peek();
        namedExpressions.forEach(expr -> newEnv.define(new Symbol(Namespace.FIELD_NAME, expr.getNameOrAlias()), expr.type()));
        return new LogicalProject(child, namedExpressions);
    }

    @Override
    public LogicalPlan visitEval(Eval node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder expressionsBuilder = new ImmutableList.Builder();
        for (Let let : node.getExpressionList()) {
            Expression expression = this.expressionAnalyzer.analyze(let.getExpression(), context);
            ReferenceExpression ref = DSL.ref(let.getVar().getField().toString(), expression.type());
            expressionsBuilder.add((Object)ImmutablePair.of((Object)ref, (Object)expression));
            TypeEnvironment typeEnvironment = context.peek();
            typeEnvironment.define(ref);
        }
        return new LogicalEval(child, (List<Pair<ReferenceExpression, Expression>>)expressionsBuilder.build());
    }

    @Override
    public LogicalPlan visitSort(Sort node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ExpressionReferenceOptimizer optimizer = new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child);
        List<Pair<Sort.SortOption, Expression>> sortList = node.getSortList().stream().map(sortField -> {
            Expression expression = optimizer.optimize(this.expressionAnalyzer.analyze(sortField.getField(), context), context);
            return ImmutablePair.of((Object)this.analyzeSortOption(sortField.getFieldArgs()), (Object)expression);
        }).collect(Collectors.toList());
        return new LogicalSort(child, sortList);
    }

    @Override
    public LogicalPlan visitDedupe(Dedupe node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        List<Argument> options = node.getOptions();
        Integer allowedDuplication = (Integer)options.get(0).getValue().getValue();
        Boolean keepEmpty = (Boolean)options.get(1).getValue().getValue();
        Boolean consecutive = (Boolean)options.get(2).getValue().getValue();
        return new LogicalDedupe(child, node.getFields().stream().map(f -> this.expressionAnalyzer.analyze((UnresolvedExpression)f, context)).collect(Collectors.toList()), allowedDuplication, keepEmpty, consecutive);
    }

    @Override
    public LogicalPlan visitHead(Head node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        return new LogicalLimit(child, node.getSize(), 0);
    }

    @Override
    public LogicalPlan visitValues(Values node, AnalysisContext context) {
        List<List<Literal>> values = node.getValues();
        ArrayList<List<LiteralExpression>> valueExprs = new ArrayList<List<LiteralExpression>>();
        for (List<Literal> value : values) {
            valueExprs.add(value.stream().map(val -> (LiteralExpression)this.expressionAnalyzer.analyze((UnresolvedExpression)val, context)).collect(Collectors.toList()));
        }
        return new LogicalValues((List<List<LiteralExpression>>)valueExprs);
    }

    private Sort.SortOption analyzeSortOption(List<Argument> fieldArgs) {
        Boolean asc = (Boolean)fieldArgs.get(0).getValue().getValue();
        Optional<Argument> nullFirst = fieldArgs.stream().filter(option -> "nullFirst".equals(option.getArgName())).findFirst();
        if (nullFirst.isPresent()) {
            Boolean isNullFirst = (Boolean)nullFirst.get().getValue().getValue();
            return new Sort.SortOption(asc != false ? Sort.SortOrder.ASC : Sort.SortOrder.DESC, isNullFirst != false ? Sort.NullOrder.NULL_FIRST : Sort.NullOrder.NULL_LAST);
        }
        return asc != false ? Sort.SortOption.DEFAULT_ASC : Sort.SortOption.DEFAULT_DESC;
    }
}

