/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.security;

import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import com.amazon.opendistroforelasticsearch.reportsscheduler.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.reportsscheduler.security.UserAccessManager;
import com.amazon.opendistroforelasticsearch.reportsscheduler.security.UserAccessManager$WhenMappings;
import com.amazon.opendistroforelasticsearch.reportsscheduler.settings.PluginSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0016\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u001b\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/security/UserAccessManager;", "", "()V", "ALL_ACCESS_ROLE", "", "BACKEND_ROLE_TAG", "DEFAULT_TENANT", "KIBANA_SERVER_USER", "PRIVATE_TENANT", "ROLE_TAG", "USER_TAG", "canAdminViewAllItems", "", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "doesUserHasAccess", "tenant", "access", "", "getAllAccessInfo", "getSearchAccessInfo", "getUserTenant", "hasAllInfoAccess", "isAdminUser", "isUserPrivateTenant", "validatePollingUser", "", "validateUser", "opendistro-reports-scheduler"})
public final class UserAccessManager {
    private static final String USER_TAG = "User:";
    private static final String ROLE_TAG = "Role:";
    private static final String BACKEND_ROLE_TAG = "BERole:";
    private static final String ALL_ACCESS_ROLE = "all_access";
    private static final String KIBANA_SERVER_USER = "kibanaserver";
    private static final String PRIVATE_TENANT = "__user__";
    @NotNull
    public static final String DEFAULT_TENANT = "";
    public static final UserAccessManager INSTANCE;

    /*
     * Enabled aggressive block sorting
     */
    public final void validateUser(@Nullable User user) {
        if (this.isUserPrivateTenant(user)) {
            User user2 = user;
            if ((user2 != null ? user2.getName() : null) == null) {
                Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                throw (Throwable)new ElasticsearchStatusException("User name not provided for private tenant access", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
        switch (UserAccessManager$WhenMappings.$EnumSwitchMapping$0[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                Object object = user;
                if (object != null && (object = object.getName()) != null) {
                    return;
                }
                UserAccessManager userAccessManager = this;
                boolean bl = false;
                boolean bl2 = false;
                UserAccessManager $this$run = userAccessManager;
                boolean bl3 = false;
                Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                throw (Throwable)new ElasticsearchStatusException("Filter-by enabled with security disabled", RestStatus.FORBIDDEN, new Object[0]);
            }
            case 3: {
                if (user != null) {
                    Collection collection = user.getRoles();
                    boolean bl = false;
                    boolean bl4 = false;
                    if (!(collection == null || collection.isEmpty())) {
                        if (user.getRoles().stream().filter(validateUser.2.INSTANCE).count() != 0L) return;
                        Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                        throw (Throwable)new ElasticsearchStatusException("No distinguishing roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
                    }
                }
                Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                throw (Throwable)new ElasticsearchStatusException("User doesn't have roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
            }
            case 4: {
                User user3 = user;
                Collection collection = user3 != null ? user3.getBackendRoles() : null;
                boolean bl = false;
                boolean bl5 = false;
                if (!(collection == null || collection.isEmpty())) return;
                Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
                throw (Throwable)new ElasticsearchStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
    }

    public final void validatePollingUser(@Nullable User user) {
        if (user != null && Intrinsics.areEqual((Object)user.getName(), (Object)KIBANA_SERVER_USER) ^ true) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Permission denied", RestStatus.FORBIDDEN, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getUserTenant(@Nullable User user) {
        void var2_2;
        User user2 = user;
        String requestedTenant = user2 != null ? user2.getRequestedTenant() : null;
        return requestedTenant == null ? DEFAULT_TENANT : var2_2;
    }

    @NotNull
    public final List<String> getAllAccessInfo(@Nullable User user) {
        String it;
        if (user == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List retList = new ArrayList();
        if (user.getName() != null) {
            retList.add(USER_TAG + user.getName());
        }
        List list = user.getRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.roles");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl2 = false;
            retList.add(ROLE_TAG + it);
        }
        List list2 = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"user.backendRoles");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl3 = false;
            retList.add(BACKEND_ROLE_TAG + it);
        }
        return retList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSearchAccessInfo(@Nullable User user) {
        List list;
        if (user == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        if (this.isUserPrivateTenant(user)) {
            return CollectionsKt.listOf((Object)(USER_TAG + user.getName()));
        }
        if (this.canAdminViewAllItems(user)) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        switch (UserAccessManager$WhenMappings.$EnumSwitchMapping$1[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1: {
                boolean bl = false;
                list = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)(USER_TAG + user.getName()));
                break;
            }
            case 3: {
                List list2 = user.getRoles().stream().filter(getSearchAccessInfo.1.INSTANCE).map(getSearchAccessInfo.2.INSTANCE).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list2, (String)"user.roles.stream()\n    \u2026lect(Collectors.toList())");
                list = list2;
                break;
            }
            case 4: {
                void $this$mapTo$iv$iv;
                List list3 = user.getBackendRoles();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"user.backendRoles");
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = BACKEND_ROLE_TAG + (String)it;
                    collection.add(string2);
                }
                list = (List)destination$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean doesUserHasAccess(@Nullable User user, @NotNull String tenant, @NotNull List<String> access) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        if (user == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)tenant) ^ true) {
            return false;
        }
        if (this.canAdminViewAllItems(user)) {
            return true;
        }
        block0 : switch (UserAccessManager$WhenMappings.$EnumSwitchMapping$2[PluginSettings.INSTANCE.getFilterBy().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = access.contains(USER_TAG + user.getName());
                break;
            }
            case 3: {
                bl = user.getRoles().stream().filter(doesUserHasAccess.1.INSTANCE).map(doesUserHasAccess.2.INSTANCE).anyMatch((Predicate)new Predicate<String>(access){
                    final /* synthetic */ List $access;

                    public final boolean test(String it) {
                        return this.$access.contains(it);
                    }
                    {
                        this.$access = list;
                    }
                });
                break;
            }
            case 4: {
                void $this$mapTo$iv$iv;
                List list = user.getBackendRoles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string2 = BACKEND_ROLE_TAG + (String)it;
                    collection.add(string2);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!access.contains(it)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean hasAllInfoAccess(@Nullable User user) {
        if (user == null) {
            return true;
        }
        return this.isAdminUser(user);
    }

    private final boolean canAdminViewAllItems(User user) {
        return PluginSettings.INSTANCE.getAdminAccess() == PluginSettings.AdminAccess.AllReports && this.isAdminUser(user);
    }

    private final boolean isAdminUser(User user) {
        return user.getRoles().contains(ALL_ACCESS_ROLE);
    }

    private final boolean isUserPrivateTenant(User user) {
        return Intrinsics.areEqual((Object)this.getUserTenant(user), (Object)PRIVATE_TENANT);
    }

    private UserAccessManager() {
    }

    static {
        UserAccessManager userAccessManager;
        INSTANCE = userAccessManager = new UserAccessManager();
    }
}

