/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.resthandler;

import com.amazon.opendistroforelasticsearch.reportsscheduler.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.BaseResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00028\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/resthandler/RestResponseToXContentListener;", "Response", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/BaseResponse;", "Lorg/elasticsearch/rest/action/RestToXContentListener;", "channel", "Lorg/elasticsearch/rest/RestChannel;", "(Lorg/elasticsearch/rest/RestChannel;)V", "buildResponse", "Lorg/elasticsearch/rest/RestResponse;", "response", "builder", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "(Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/BaseResponse;Lorg/elasticsearch/common/xcontent/XContentBuilder;)Lorg/elasticsearch/rest/RestResponse;", "getStatus", "Lorg/elasticsearch/rest/RestStatus;", "(Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/BaseResponse;)Lorg/elasticsearch/rest/RestStatus;", "opendistro-reports-scheduler"})
public final class RestResponseToXContentListener<Response extends BaseResponse>
extends RestToXContentListener<Response> {
    @Nullable
    public RestResponse buildResponse(@NotNull Response response, @Nullable XContentBuilder builder) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        super.buildResponse((ToXContentObject)response, builder);
        Metrics.REQUEST_TOTAL.getCounter().increment();
        Metrics.REQUEST_INTERVAL_COUNT.getCounter().increment();
        RestStatus restStatus = ((BaseResponse)((Object)response)).getStatus();
        Comparable comparable = (Comparable)restStatus;
        if (comparable.compareTo((Comparable)RestStatus.OK) >= 0 && comparable.compareTo((Comparable)RestStatus.MULTI_STATUS) <= 0) {
            Metrics.REQUEST_SUCCESS.getCounter().increment();
        } else if (restStatus == RestStatus.FORBIDDEN) {
            Metrics.REPORT_SECURITY_PERMISSION_ERROR.getCounter().increment();
        } else {
            comparable = (Comparable)restStatus;
            if (comparable.compareTo((Comparable)RestStatus.UNAUTHORIZED) >= 0 && comparable.compareTo((Comparable)RestStatus.TOO_MANY_REQUESTS) <= 0) {
                Metrics.REQUEST_USER_ERROR.getCounter().increment();
            } else {
                Metrics.REQUEST_SYSTEM_ERROR.getCounter().increment();
            }
        }
        return (RestResponse)new BytesRestResponse(this.getStatus(response), builder);
    }

    @NotNull
    protected RestStatus getStatus(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        return ((BaseResponse)((Object)response)).getStatus();
    }

    public RestResponseToXContentListener(@NotNull RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(channel);
    }
}

