/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.resthandler;

import com.amazon.opendistroforelasticsearch.reportsscheduler.action.GetReportInstanceAction;
import com.amazon.opendistroforelasticsearch.reportsscheduler.action.UpdateReportInstanceStatusAction;
import com.amazon.opendistroforelasticsearch.reportsscheduler.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetReportInstanceRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetReportInstanceResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.UpdateReportInstanceStatusRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.UpdateReportInstanceStatusResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.resthandler.PluginBaseHandler;
import com.amazon.opendistroforelasticsearch.reportsscheduler.resthandler.ReportInstanceRestHandler$WhenMappings;
import com.amazon.opendistroforelasticsearch.reportsscheduler.resthandler.RestResponseToXContentListener;
import com.amazon.opendistroforelasticsearch.reportsscheduler.util.HelpersKt;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0014J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/resthandler/ReportInstanceRestHandler;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/resthandler/PluginBaseHandler;", "()V", "executeRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "getName", "", "responseParams", "", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "Companion", "opendistro-reports-scheduler"})
public final class ReportInstanceRestHandler
extends PluginBaseHandler {
    private static final String REPORT_INSTANCE_LIST_ACTION = "report_instance_actions";
    private static final String REPORT_INSTANCE_URL = "/_opendistro/_reports/instance";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return REPORT_INSTANCE_LIST_ACTION;
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, "/_opendistro/_reports/instance/{reportInstanceId}"), new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_reports/instance/{reportInstanceId}")});
    }

    @NotNull
    protected Set<String> responseParams() {
        return SetsKt.setOf((Object)"reportInstanceId");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected BaseRestHandler.RestChannelConsumer executeRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        BaseRestHandler.RestChannelConsumer restChannelConsumer;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String string = request.param("reportInstanceId");
        if (string == null) throw (Throwable)new IllegalArgumentException("Must specify id");
        String reportInstanceId = string;
        RestRequest.Method method = request.method();
        if (method != null) {
            switch (ReportInstanceRestHandler$WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
                case 1: {
                    restChannelConsumer = new BaseRestHandler.RestChannelConsumer(client, request, reportInstanceId){
                        final /* synthetic */ NodeClient $client;
                        final /* synthetic */ RestRequest $request;
                        final /* synthetic */ String $reportInstanceId;

                        public final void accept(RestChannel it) {
                            Metrics.REPORT_INSTANCE_UPDATE_TOTAL.getCounter().increment();
                            Metrics.REPORT_INSTANCE_UPDATE_INTERVAL_COUNT.getCounter().increment();
                            ActionType<UpdateReportInstanceStatusResponse> actionType = UpdateReportInstanceStatusAction.Companion.getACTION_TYPE$opendistro_reports_scheduler();
                            ActionRequest actionRequest = UpdateReportInstanceStatusRequest.Companion.parse(HelpersKt.contentParserNextToken(this.$request), this.$reportInstanceId);
                            RestChannel restChannel = it;
                            Intrinsics.checkNotNullExpressionValue((Object)restChannel, (String)"it");
                            this.$client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener<Response>(restChannel));
                        }
                        {
                            this.$client = nodeClient;
                            this.$request = restRequest;
                            this.$reportInstanceId = string;
                        }
                    };
                    return restChannelConsumer;
                }
                case 2: {
                    restChannelConsumer = new BaseRestHandler.RestChannelConsumer(client, reportInstanceId){
                        final /* synthetic */ NodeClient $client;
                        final /* synthetic */ String $reportInstanceId;

                        public final void accept(RestChannel it) {
                            Metrics.REPORT_INSTANCE_INFO_TOTAL.getCounter().increment();
                            Metrics.REPORT_INSTANCE_INFO_INTERVAL_COUNT.getCounter().increment();
                            ActionType<GetReportInstanceResponse> actionType = GetReportInstanceAction.Companion.getACTION_TYPE$opendistro_reports_scheduler();
                            ActionRequest actionRequest = new GetReportInstanceRequest(this.$reportInstanceId);
                            RestChannel restChannel = it;
                            Intrinsics.checkNotNullExpressionValue((Object)restChannel, (String)"it");
                            this.$client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener<Response>(restChannel));
                        }
                        {
                            this.$client = nodeClient;
                            this.$reportInstanceId = string;
                        }
                    };
                    return restChannelConsumer;
                }
            }
        }
        restChannelConsumer = new BaseRestHandler.RestChannelConsumer(request){
            final /* synthetic */ RestRequest $request;

            public final void accept(RestChannel it) {
                it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, this.$request.method() + " is not allowed"));
            }
            {
                this.$request = restRequest;
            }
        };
        return restChannelConsumer;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/resthandler/ReportInstanceRestHandler$Companion;", "", "()V", "REPORT_INSTANCE_LIST_ACTION", "", "REPORT_INSTANCE_URL", "opendistro-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

