/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.model;

import com.amazon.opendistroforelasticsearch.reportsscheduler.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportDefinitionDetails;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportInstance;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.RestTag;
import com.amazon.opendistroforelasticsearch.reportsscheduler.util.HelpersKt;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)BA\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020!J\u001c\u0010\u001e\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/InContextReportCreateRequest;", "Lorg/elasticsearch/action/ActionRequest;", "Lorg/elasticsearch/common/xcontent/ToXContentObject;", "beginTime", "Ljava/time/Instant;", "endTime", "reportDefinitionDetails", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportDefinitionDetails;", "status", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportInstance$Status;", "statusText", "", "inContextDownloadUrlPath", "(Ljava/time/Instant;Ljava/time/Instant;Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportDefinitionDetails;Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportInstance$Status;Ljava/lang/String;Ljava/lang/String;)V", "input", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "parser", "Lorg/elasticsearch/common/xcontent/XContentParser;", "(Lorg/elasticsearch/common/xcontent/XContentParser;)V", "getBeginTime", "()Ljava/time/Instant;", "getEndTime", "getInContextDownloadUrlPath", "()Ljava/lang/String;", "getReportDefinitionDetails", "()Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportDefinitionDetails;", "getStatus", "()Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportInstance$Status;", "getStatusText", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "builder", "validate", "Lorg/elasticsearch/action/ActionRequestValidationException;", "writeTo", "", "output", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "opendistro-reports-scheduler"})
public final class InContextReportCreateRequest
extends ActionRequest
implements ToXContentObject {
    @NotNull
    private final Instant beginTime;
    @NotNull
    private final Instant endTime;
    @Nullable
    private final ReportDefinitionDetails reportDefinitionDetails;
    @NotNull
    private final ReportInstance.Status status;
    @Nullable
    private final String statusText;
    @Nullable
    private final String inContextDownloadUrlPath;
    private static final Lazy log$delegate;
    public static final Companion Companion;

    @NotNull
    public final Instant getBeginTime() {
        return this.beginTime;
    }

    @NotNull
    public final Instant getEndTime() {
        return this.endTime;
    }

    @Nullable
    public final ReportDefinitionDetails getReportDefinitionDetails() {
        return this.reportDefinitionDetails;
    }

    @NotNull
    public final ReportInstance.Status getStatus() {
        return this.status;
    }

    @Nullable
    public final String getStatusText() {
        return this.statusText;
    }

    @Nullable
    public final String getInContextDownloadUrlPath() {
        return this.inContextDownloadUrlPath;
    }

    public void writeTo(@NotNull StreamOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.toXContent(XContentFactory.jsonBuilder((OutputStream)((OutputStream)output)), ToXContent.EMPTY_PARAMS);
    }

    @Nullable
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(InContextReportCreateRequest inContextReportCreateRequest, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"ToXContent.EMPTY_PARAMS");
            params = params2;
        }
        return inContextReportCreateRequest.toXContent(params);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        xContentBuilder.startObject().field("beginTimeMs", this.beginTime.toEpochMilli()).field("endTimeMs", this.endTime.toEpochMilli());
        if (this.reportDefinitionDetails != null) {
            builder.field("reportDefinitionDetails");
            this.reportDefinitionDetails.toXContent(builder, RestTag.INSTANCE.getREST_OUTPUT_PARAMS());
        }
        XContentBuilder xContentBuilder2 = builder.field("status", this.status.name());
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.field(STATUS_FIELD, status.name)");
        XContentBuilder xContentBuilder3 = HelpersKt.fieldIfNotNull(HelpersKt.fieldIfNotNull(xContentBuilder2, "statusText", this.statusText), "inContextDownloadUrlPath", this.inContextDownloadUrlPath).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder3, (String)"builder.field(STATUS_FIE\u2026\n            .endObject()");
        return xContentBuilder3;
    }

    @Nullable
    public ActionRequestValidationException validate() {
        return null;
    }

    public InContextReportCreateRequest(@NotNull Instant beginTime, @NotNull Instant endTime, @Nullable ReportDefinitionDetails reportDefinitionDetails, @NotNull ReportInstance.Status status, @Nullable String statusText, @Nullable String inContextDownloadUrlPath) {
        Intrinsics.checkNotNullParameter((Object)beginTime, (String)"beginTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.reportDefinitionDetails = reportDefinitionDetails;
        this.status = status;
        this.statusText = statusText;
        this.inContextDownloadUrlPath = inContextDownloadUrlPath;
    }

    public /* synthetic */ InContextReportCreateRequest(Instant instant, Instant instant2, ReportDefinitionDetails reportDefinitionDetails, ReportInstance.Status status, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        this(instant, instant2, reportDefinitionDetails, status, string, string2);
    }

    public InContextReportCreateRequest(@NotNull StreamInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(HelpersKt.createJsonParser(input));
    }

    public InContextReportCreateRequest(@NotNull XContentParser parser) {
        InContextReportCreateRequest inContextReportCreateRequest;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Instant beginTime = null;
        Instant endTime = null;
        ReportDefinitionDetails reportDefinitionDetails = null;
        ReportInstance.Status status = null;
        String statusText = null;
        String inContextDownloadUrlPath = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (fieldName != null) {
                String string;
                int n = -1;
                switch (string.hashCode()) {
                    case 121872994: {
                        if (!string.equals("inContextDownloadUrlPath")) break;
                        n = 1;
                        break;
                    }
                    case -207003812: {
                        if (!string.equals("beginTimeMs")) break;
                        n = 2;
                        break;
                    }
                    case 248004671: {
                        if (!string.equals("statusText")) break;
                        n = 3;
                        break;
                    }
                    case -1906132325: {
                        if (!string.equals("reportDefinitionDetails")) break;
                        n = 4;
                        break;
                    }
                    case 1627521550: {
                        if (!string.equals("endTimeMs")) break;
                        n = 5;
                        break;
                    }
                    case -892481550: {
                        if (!string.equals("status")) break;
                        n = 6;
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        beginTime = Instant.ofEpochMilli(parser.longValue());
                        continue block16;
                    }
                    case 5: {
                        endTime = Instant.ofEpochMilli(parser.longValue());
                        continue block16;
                    }
                    case 4: {
                        reportDefinitionDetails = ReportDefinitionDetails.Companion.parse$default(ReportDefinitionDetails.Companion, parser, null, 2, null);
                        continue block16;
                    }
                    case 6: {
                        String string2 = parser.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                        status = ReportInstance.Status.valueOf(string2);
                        continue block16;
                    }
                    case 3: {
                        statusText = parser.text();
                        continue block16;
                    }
                    case 1: {
                        inContextDownloadUrlPath = parser.text();
                        continue block16;
                    }
                }
            }
            parser.skipChildren();
            InContextReportCreateRequest.Companion.getLog().info("reports:InContextReportCreateRequest Skipping Unknown field " + fieldName);
        }
        if (beginTime == null) {
            inContextReportCreateRequest = this;
            boolean bl = false;
            boolean bl2 = false;
            InContextReportCreateRequest $this$run = inContextReportCreateRequest;
            boolean bl3 = false;
            Metrics.REPORT_FROM_DEFINITION_USER_ERROR_INVALID_BEGIN_TIME.getCounter().increment();
            throw (Throwable)new IllegalArgumentException("beginTimeMs field absent");
        }
        if (endTime == null) {
            inContextReportCreateRequest = this;
            boolean bl = false;
            boolean bl4 = false;
            InContextReportCreateRequest $this$run = inContextReportCreateRequest;
            boolean bl5 = false;
            Metrics.REPORT_FROM_DEFINITION_USER_ERROR_INVALID_END_TIME.getCounter().increment();
            throw (Throwable)new IllegalArgumentException("endTimeMs field absent");
        }
        if (status == null) {
            inContextReportCreateRequest = this;
            boolean bl = false;
            boolean bl6 = false;
            InContextReportCreateRequest $this$run = inContextReportCreateRequest;
            boolean bl7 = false;
            Metrics.REPORT_FROM_DEFINITION_USER_ERROR_INVALID_STATUS.getCounter().increment();
            throw (Throwable)new IllegalArgumentException("status field absent");
        }
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.reportDefinitionDetails = reportDefinitionDetails;
        this.status = status;
        this.statusText = statusText;
        this.inContextDownloadUrlPath = inContextDownloadUrlPath;
    }

    static {
        Companion = new Companion(null);
        log$delegate = HelpersKt.logger(InContextReportCreateRequest.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/InContextReportCreateRequest$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "opendistro-reports-scheduler"})
    public static final class Companion {
        private final Logger getLog() {
            Lazy lazy = log$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

