/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.metrics;

import com.amazon.opendistroforelasticsearch.reportsscheduler.metrics.Counter;
import java.time.Clock;
import java.util.concurrent.ConcurrentSkipListMap;

public class RollingCounter
implements Counter<Long> {
    private static final long METRICS_ROLLING_WINDOW_VALUE = 3600L;
    private static final long METRICS_ROLLING_INTERVAL_VALUE = 60L;
    private final long capacity;
    private final long window;
    private final long interval;
    private final Clock clock;
    private final ConcurrentSkipListMap<Long, Long> timeToCountMap = new ConcurrentSkipListMap();

    public RollingCounter() {
        this(3600L, 60L);
    }

    public RollingCounter(long window, long interval, Clock clock) {
        this.window = window;
        this.interval = interval;
        this.clock = clock;
        this.capacity = window / interval * 2L;
    }

    public RollingCounter(long window, long interval) {
        this(window, interval, Clock.systemDefaultZone());
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    @Override
    public void add(long n) {
        this.trim();
        this.timeToCountMap.compute(this.getKey(this.clock.millis()), (k, v) -> v == null ? n : v + n);
    }

    @Override
    public Long getValue() {
        return this.getValue(this.getPreKey(this.clock.millis()));
    }

    public long getValue(long key) {
        Long res = this.timeToCountMap.get(key);
        if (res == null) {
            return 0L;
        }
        return res;
    }

    private void trim() {
        if ((long)this.timeToCountMap.size() > this.capacity) {
            this.timeToCountMap.headMap((Object)this.getKey(this.clock.millis() - this.window * 1000L)).clear();
        }
    }

    private long getKey(long millis) {
        return millis / 1000L / this.interval;
    }

    private long getPreKey(long millis) {
        return this.getKey(millis) - 1L;
    }

    public int size() {
        return this.timeToCountMap.size();
    }

    @Override
    public void reset() {
        this.timeToCountMap.clear();
    }
}

