/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.index;

import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportInstance;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportInstanceDoc;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportInstanceSearchResults;
import com.amazon.opendistroforelasticsearch.reportsscheduler.settings.PluginSettings;
import com.amazon.opendistroforelasticsearch.reportsscheduler.util.HelpersKt;
import com.amazon.opendistroforelasticsearch.reportsscheduler.util.SecureIndexClient;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J,\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u0010\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010&\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010'\u001a\u00020\u0018H\u0002J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006+"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/index/ReportInstancesIndex;", "", "()V", "MAPPING_TYPE", "", "REPORT_INSTANCES_INDEX_NAME", "REPORT_INSTANCES_MAPPING_FILE_NAME", "REPORT_INSTANCES_SETTINGS_FILE_NAME", "client", "Lorg/elasticsearch/client/Client;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createIndex", "", "createReportInstance", "reportInstance", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportInstance;", "deleteReportInstance", "", "id", "getAllReportInstances", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportInstanceSearchResults;", "tenant", "access", "", "from", "", "maxItems", "getPendingReportInstances", "", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportInstanceDoc;", "getReportInstance", "initialize", "isIndexExists", "updateReportInstance", "updateReportInstanceDoc", "reportInstanceDoc", "opendistro-reports-scheduler"})
public final class ReportInstancesIndex {
    private static final Lazy log$delegate;
    private static final String REPORT_INSTANCES_INDEX_NAME = ".opendistro-reports-instances";
    private static final String REPORT_INSTANCES_MAPPING_FILE_NAME = "report-instances-mapping.yml";
    private static final String REPORT_INSTANCES_SETTINGS_FILE_NAME = "report-instances-settings.yml";
    private static final String MAPPING_TYPE = "_doc";
    private static Client client;
    private static ClusterService clusterService;
    public static final ReportInstancesIndex INSTANCE;

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        ReportInstancesIndex reportInstancesIndex = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ReportInstancesIndex.client = new SecureIndexClient(client);
        ReportInstancesIndex.clusterService = clusterService;
    }

    private final void createIndex() {
        block9: {
            if (!this.isIndexExists()) {
                String string;
                String string2;
                boolean bl;
                Object object;
                ClassLoader classLoader = ReportInstancesIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(REPORT_INSTANCES_MAPPING_FILE_NAME);
                if (uRL != null) {
                    URL uRL2 = uRL;
                    object = Charsets.UTF_8;
                    boolean bl2 = false;
                    byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                    boolean bl3 = false;
                    bl = false;
                    string2 = new String(byArray, (Charset)object);
                } else {
                    string2 = null;
                }
                Intrinsics.checkNotNull(string2);
                String indexMappingSource = string2;
                URL uRL3 = classLoader.getResource(REPORT_INSTANCES_SETTINGS_FILE_NAME);
                if (uRL3 != null) {
                    object = uRL3;
                    Charset charset = Charsets.UTF_8;
                    boolean bl4 = false;
                    byte[] byArray = TextStreamsKt.readBytes((URL)object);
                    bl = false;
                    boolean bl5 = false;
                    string = new String(byArray, charset);
                } else {
                    string = null;
                }
                Intrinsics.checkNotNull(string);
                String indexSettingsSource = string;
                CreateIndexRequest request = new CreateIndexRequest(REPORT_INSTANCES_INDEX_NAME).mapping(MAPPING_TYPE, indexMappingSource, XContentType.YAML).settings(indexSettingsSource, XContentType.YAML);
                try {
                    CreateIndexResponse response;
                    Client client = ReportInstancesIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    }
                    ActionFuture actionFuture = client.admin().indices().create(request);
                    CreateIndexResponse createIndexResponse = response = (CreateIndexResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
                    Intrinsics.checkNotNullExpressionValue((Object)createIndexResponse, (String)"response");
                    if (!createIndexResponse.isAcknowledged()) {
                        throw (Throwable)new IllegalStateException("reports:Index .opendistro-reports-instances creation not Acknowledged");
                    }
                    this.getLog().info("reports:Index .opendistro-reports-instances creation Acknowledged");
                }
                catch (Exception exception) {
                    if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) break block9;
                    throw (Throwable)exception;
                }
            }
        }
    }

    private final boolean isIndexExists() {
        ClusterState clusterState;
        ClusterService clusterService = ReportInstancesIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
        }
        ClusterState clusterState2 = clusterState = clusterService.state();
        Intrinsics.checkNotNullExpressionValue((Object)clusterState2, (String)"clusterState");
        return clusterState2.getRoutingTable().hasIndex(REPORT_INSTANCES_INDEX_NAME);
    }

    @Nullable
    public final String createReportInstance(@NotNull ReportInstance reportInstance) {
        String string;
        IndexResponse response;
        Intrinsics.checkNotNullParameter((Object)reportInstance, (String)"reportInstance");
        this.createIndex();
        IndexRequest indexRequest = new IndexRequest(REPORT_INSTANCES_INDEX_NAME).source(ReportInstance.toXContent$default(reportInstance, null, 1, null)).create(true);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.index(indexRequest);
        IndexResponse indexResponse = response = (IndexResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)indexResponse, (String)"response");
        if (indexResponse.getResult() != DocWriteResponse.Result.CREATED) {
            this.getLog().warn("reports:createReportInstance - response:" + response);
            string = null;
        } else {
            string = response.getId();
        }
        return string;
    }

    @Nullable
    public final ReportInstance getReportInstance(@NotNull String id) {
        ReportInstance reportInstance;
        GetResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        GetRequest getRequest = new GetRequest(REPORT_INSTANCES_INDEX_NAME).id(id);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.get(getRequest);
        GetResponse getResponse = response = (GetResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)getResponse, (String)"response");
        if (getResponse.getSourceAsString() == null) {
            this.getLog().warn("reports:getReportInstance - " + id + " not found; response:" + response);
            reportInstance = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            XContentParser xContentParser = parser;
            Intrinsics.checkNotNullExpressionValue((Object)xContentParser, (String)"parser");
            reportInstance = ReportInstance.Companion.parse(xContentParser, id);
        }
        return reportInstance;
    }

    @NotNull
    public final ReportInstanceSearchResults getAllReportInstances(@NotNull String tenant, @NotNull List<String> access, int from, int maxItems) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.createIndex();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).sort("lastUpdatedTimeMs").size(maxItems).from(from);
        TermsQueryBuilder tenantQuery = QueryBuilders.termsQuery((String)"tenant", (String[])new String[]{tenant});
        Collection collection = access;
        boolean bl = false;
        if (!collection.isEmpty()) {
            TermsQueryBuilder accessQuery = QueryBuilders.termsQuery((String)"access", (Collection)access);
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.filter((QueryBuilder)tenantQuery);
            query.filter((QueryBuilder)accessQuery);
            sourceBuilder.query((QueryBuilder)query);
        } else {
            sourceBuilder.query((QueryBuilder)tenantQuery);
        }
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{REPORT_INSTANCES_INDEX_NAME}).source(sourceBuilder);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        long l = from;
        SearchResponse searchResponse = response;
        Intrinsics.checkNotNullExpressionValue((Object)searchResponse, (String)"response");
        ReportInstanceSearchResults result = new ReportInstanceSearchResults(l, searchResponse);
        this.getLog().info("reports:getAllReportInstances from:" + from + ", maxItems:" + maxItems + ',' + " retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
        return result;
    }

    public final boolean updateReportInstance(@NotNull ReportInstance reportInstance) {
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)reportInstance, (String)"reportInstance");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(REPORT_INSTANCES_INDEX_NAME)).id(reportInstance.getId()).doc(ReportInstance.toXContent$default(reportInstance, null, 1, null)).fetchSource(true);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.update(updateRequest);
        UpdateResponse updateResponse = response = (UpdateResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)updateResponse, (String)"response");
        if (updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
            this.getLog().warn("reports:updateReportInstance failed for " + reportInstance.getId() + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean updateReportInstanceDoc(@NotNull ReportInstanceDoc reportInstanceDoc) {
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)reportInstanceDoc, (String)"reportInstanceDoc");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(REPORT_INSTANCES_INDEX_NAME)).id(reportInstanceDoc.getReportInstance().getId()).setIfSeqNo(reportInstanceDoc.getSeqNo()).setIfPrimaryTerm(reportInstanceDoc.getPrimaryTerm()).doc(ReportInstance.toXContent$default(reportInstanceDoc.getReportInstance(), null, 1, null)).fetchSource(true);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.update(updateRequest);
        UpdateResponse updateResponse = response = (UpdateResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)updateResponse, (String)"response");
        if (updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
            this.getLog().warn("reports:updateReportInstanceDoc failed for " + reportInstanceDoc.getReportInstance().getId() + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean deleteReportInstance(@NotNull String id) {
        DeleteResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(REPORT_INSTANCES_INDEX_NAME)).id(id);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.delete(deleteRequest);
        DeleteResponse deleteResponse = response = (DeleteResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)deleteResponse, (String)"response");
        if (deleteResponse.getResult() != DocWriteResponse.Result.DELETED) {
            this.getLog().warn("reports:deleteReportInstance failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.DELETED;
    }

    @NotNull
    public final List<ReportInstanceDoc> getPendingReportInstances() {
        SearchResponse response;
        this.createIndex();
        TermsQueryBuilder query = QueryBuilders.termsQuery((String)"status", (String[])new String[]{ReportInstance.Status.Scheduled.name(), ReportInstance.Status.Executing.name()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).size(PluginSettings.INSTANCE.getDefaultItemsQueryCount()).query((QueryBuilder)query);
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{REPORT_INSTANCES_INDEX_NAME}).source(sourceBuilder);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse searchResponse = response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)searchResponse, (String)"response");
        SearchHits hits = searchResponse.getHits();
        Logger logger2 = this.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("reports:getPendingReportInstances; totalHits:");
        SearchHits searchHits = hits;
        Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"hits");
        logger2.info(stringBuilder.append(searchHits.getTotalHits()).append(", retHits:").append(hits.getHits().length).toString());
        boolean bl = false;
        List mutableList = new ArrayList();
        Instant currentTime = Instant.now();
        Instant refTime = currentTime.minusSeconds(PluginSettings.INSTANCE.getJobLockDurationSeconds());
        Iterable $this$forEach$iv = (Iterable)hits;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchHit it = (SearchHit)element$iv;
            boolean bl2 = false;
            XContent xContent = XContentType.JSON.xContent();
            DeprecationHandler deprecationHandler = (DeprecationHandler)LoggingDeprecationHandler.INSTANCE;
            SearchHit searchHit = it;
            Intrinsics.checkNotNullExpressionValue((Object)searchHit, (String)"it");
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, deprecationHandler, searchHit.getSourceAsString());
            parser.nextToken();
            XContentParser xContentParser = parser;
            Intrinsics.checkNotNullExpressionValue((Object)xContentParser, (String)"parser");
            ReportInstance reportInstance = ReportInstance.Companion.parse(xContentParser, it.getId());
            if (reportInstance.getStatus() != ReportInstance.Status.Scheduled && !reportInstance.getUpdatedTime().isBefore(refTime)) continue;
            mutableList.add(new ReportInstanceDoc(reportInstance, it.getSeqNo(), it.getPrimaryTerm()));
        }
        return mutableList;
    }

    private ReportInstancesIndex() {
    }

    static {
        ReportInstancesIndex reportInstancesIndex;
        INSTANCE = reportInstancesIndex = new ReportInstancesIndex();
        log$delegate = HelpersKt.logger(ReportInstancesIndex.class);
    }
}

