/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.index;

import com.amazon.opendistroforelasticsearch.reportsscheduler.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportDefinitionDetails;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportDefinitionDetailsSearchResults;
import com.amazon.opendistroforelasticsearch.reportsscheduler.settings.PluginSettings;
import com.amazon.opendistroforelasticsearch.reportsscheduler.util.HelpersKt;
import com.amazon.opendistroforelasticsearch.reportsscheduler.util.SecureIndexClient;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J,\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010$\u001a\u00020\u0018H\u0002J\u0016\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/index/ReportDefinitionsIndex;", "", "()V", "MAPPING_TYPE", "", "REPORT_DEFINITIONS_INDEX_NAME", "REPORT_DEFINITIONS_MAPPING_FILE_NAME", "REPORT_DEFINITIONS_SETTINGS_FILE_NAME", "client", "Lorg/elasticsearch/client/Client;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createIndex", "", "createReportDefinition", "reportDefinitionDetails", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportDefinitionDetails;", "deleteReportDefinition", "", "id", "getAllReportDefinitions", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/ReportDefinitionDetailsSearchResults;", "tenant", "access", "", "from", "", "maxItems", "getReportDefinition", "initialize", "isIndexExists", "updateReportDefinition", "opendistro-reports-scheduler"})
public final class ReportDefinitionsIndex {
    private static final Lazy log$delegate;
    @NotNull
    public static final String REPORT_DEFINITIONS_INDEX_NAME = ".opendistro-reports-definitions";
    private static final String REPORT_DEFINITIONS_MAPPING_FILE_NAME = "report-definitions-mapping.yml";
    private static final String REPORT_DEFINITIONS_SETTINGS_FILE_NAME = "report-definitions-settings.yml";
    private static final String MAPPING_TYPE = "_doc";
    private static Client client;
    private static ClusterService clusterService;
    public static final ReportDefinitionsIndex INSTANCE;

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        ReportDefinitionsIndex reportDefinitionsIndex = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ReportDefinitionsIndex.client = new SecureIndexClient(client);
        ReportDefinitionsIndex.clusterService = clusterService;
    }

    private final void createIndex() {
        block9: {
            if (!this.isIndexExists()) {
                String string;
                String string2;
                boolean bl;
                Object object;
                ClassLoader classLoader = ReportDefinitionsIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(REPORT_DEFINITIONS_MAPPING_FILE_NAME);
                if (uRL != null) {
                    URL uRL2 = uRL;
                    object = Charsets.UTF_8;
                    boolean bl2 = false;
                    byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                    boolean bl3 = false;
                    bl = false;
                    string2 = new String(byArray, (Charset)object);
                } else {
                    string2 = null;
                }
                Intrinsics.checkNotNull(string2);
                String indexMappingSource = string2;
                URL uRL3 = classLoader.getResource(REPORT_DEFINITIONS_SETTINGS_FILE_NAME);
                if (uRL3 != null) {
                    object = uRL3;
                    Charset charset = Charsets.UTF_8;
                    boolean bl4 = false;
                    byte[] byArray = TextStreamsKt.readBytes((URL)object);
                    bl = false;
                    boolean bl5 = false;
                    string = new String(byArray, charset);
                } else {
                    string = null;
                }
                Intrinsics.checkNotNull(string);
                String indexSettingsSource = string;
                CreateIndexRequest request = new CreateIndexRequest(REPORT_DEFINITIONS_INDEX_NAME).mapping(MAPPING_TYPE, indexMappingSource, XContentType.YAML).settings(indexSettingsSource, XContentType.YAML);
                try {
                    CreateIndexResponse response;
                    Client client = ReportDefinitionsIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    }
                    ActionFuture actionFuture = client.admin().indices().create(request);
                    CreateIndexResponse createIndexResponse = response = (CreateIndexResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
                    Intrinsics.checkNotNullExpressionValue((Object)createIndexResponse, (String)"response");
                    if (!createIndexResponse.isAcknowledged()) {
                        Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
                        throw (Throwable)new IllegalStateException("reports:Index .opendistro-reports-definitions creation not Acknowledged");
                    }
                    this.getLog().info("reports:Index .opendistro-reports-definitions creation Acknowledged");
                }
                catch (Exception exception) {
                    if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) break block9;
                    Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
                    throw (Throwable)exception;
                }
            }
        }
    }

    private final boolean isIndexExists() {
        ClusterState clusterState;
        ClusterService clusterService = ReportDefinitionsIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
        }
        ClusterState clusterState2 = clusterState = clusterService.state();
        Intrinsics.checkNotNullExpressionValue((Object)clusterState2, (String)"clusterState");
        return clusterState2.getRoutingTable().hasIndex(REPORT_DEFINITIONS_INDEX_NAME);
    }

    @Nullable
    public final String createReportDefinition(@NotNull ReportDefinitionDetails reportDefinitionDetails) {
        String string;
        IndexResponse response;
        Intrinsics.checkNotNullParameter((Object)reportDefinitionDetails, (String)"reportDefinitionDetails");
        this.createIndex();
        IndexRequest indexRequest = new IndexRequest(REPORT_DEFINITIONS_INDEX_NAME).source(ReportDefinitionDetails.toXContent$default(reportDefinitionDetails, null, 1, null)).create(true);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.index(indexRequest);
        IndexResponse indexResponse = response = (IndexResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)indexResponse, (String)"response");
        if (indexResponse.getResult() != DocWriteResponse.Result.CREATED) {
            Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:createReportDefinition - response:" + response);
            string = null;
        } else {
            string = response.getId();
        }
        return string;
    }

    @Nullable
    public final ReportDefinitionDetails getReportDefinition(@NotNull String id) {
        ReportDefinitionDetails reportDefinitionDetails;
        GetResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        GetRequest getRequest = new GetRequest(REPORT_DEFINITIONS_INDEX_NAME).id(id);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.get(getRequest);
        GetResponse getResponse = response = (GetResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)getResponse, (String)"response");
        if (getResponse.getSourceAsString() == null) {
            this.getLog().warn("reports:getReportDefinition - " + id + " not found; response:" + response);
            reportDefinitionDetails = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            XContentParser xContentParser = parser;
            Intrinsics.checkNotNullExpressionValue((Object)xContentParser, (String)"parser");
            reportDefinitionDetails = ReportDefinitionDetails.Companion.parse(xContentParser, id);
        }
        return reportDefinitionDetails;
    }

    @NotNull
    public final ReportDefinitionDetailsSearchResults getAllReportDefinitions(@NotNull String tenant, @NotNull List<String> access, int from, int maxItems) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.createIndex();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).sort("lastUpdatedTimeMs").size(maxItems).from(from);
        TermsQueryBuilder tenantQuery = QueryBuilders.termsQuery((String)"tenant", (String[])new String[]{tenant});
        Collection collection = access;
        boolean bl = false;
        if (!collection.isEmpty()) {
            TermsQueryBuilder accessQuery = QueryBuilders.termsQuery((String)"access", (Collection)access);
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.filter((QueryBuilder)tenantQuery);
            query.filter((QueryBuilder)accessQuery);
            sourceBuilder.query((QueryBuilder)query);
        } else {
            sourceBuilder.query((QueryBuilder)tenantQuery);
        }
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{REPORT_DEFINITIONS_INDEX_NAME}).source(sourceBuilder);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        long l = from;
        SearchResponse searchResponse = response;
        Intrinsics.checkNotNullExpressionValue((Object)searchResponse, (String)"response");
        ReportDefinitionDetailsSearchResults result = new ReportDefinitionDetailsSearchResults(l, searchResponse);
        this.getLog().info("reports:getAllReportDefinitions from:" + from + ", maxItems:" + maxItems + ',' + " retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
        return result;
    }

    public final boolean updateReportDefinition(@NotNull String id, @NotNull ReportDefinitionDetails reportDefinitionDetails) {
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)reportDefinitionDetails, (String)"reportDefinitionDetails");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(REPORT_DEFINITIONS_INDEX_NAME)).id(id).doc(ReportDefinitionDetails.toXContent$default(reportDefinitionDetails, null, 1, null)).fetchSource(true);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.update(updateRequest);
        UpdateResponse updateResponse = response = (UpdateResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)updateResponse, (String)"response");
        if (updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
            Metrics.REPORT_DEFINITION_UPDATE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:updateReportDefinition failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean deleteReportDefinition(@NotNull String id) {
        DeleteResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(REPORT_DEFINITIONS_INDEX_NAME)).id(id);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        ActionFuture actionFuture = client.delete(deleteRequest);
        DeleteResponse deleteResponse = response = (DeleteResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)deleteResponse, (String)"response");
        if (deleteResponse.getResult() != DocWriteResponse.Result.DELETED) {
            Metrics.REPORT_DEFINITION_DELETE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:deleteReportDefinition failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.DELETED;
    }

    private ReportDefinitionsIndex() {
    }

    static {
        ReportDefinitionsIndex reportDefinitionsIndex;
        INSTANCE = reportDefinitionsIndex = new ReportDefinitionsIndex();
        log$delegate = HelpersKt.logger(ReportDefinitionsIndex.class);
    }
}

