/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.action;

import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import com.amazon.opendistroforelasticsearch.reportsscheduler.index.ReportDefinitionsIndex;
import com.amazon.opendistroforelasticsearch.reportsscheduler.index.ReportInstancesIndex;
import com.amazon.opendistroforelasticsearch.reportsscheduler.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetAllReportInstancesRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetAllReportInstancesResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetReportInstanceRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetReportInstanceResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.InContextReportCreateRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.InContextReportCreateResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.OnDemandReportCreateRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.OnDemandReportCreateResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.PollReportInstanceResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportDefinitionDetails;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportInstance;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportInstanceDoc;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportInstanceSearchResults;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.UpdateReportInstanceStatusRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.UpdateReportInstanceStatusResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.security.UserAccessManager;
import com.amazon.opendistroforelasticsearch.reportsscheduler.settings.PluginSettings;
import com.amazon.opendistroforelasticsearch.reportsscheduler.util.HelpersKt;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\u001e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/action/ReportInstanceActions;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createOnDemand", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/InContextReportCreateResponse;", "request", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/InContextReportCreateRequest;", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "createOnDemandFromDefinition", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/OnDemandReportCreateResponse;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/OnDemandReportCreateRequest;", "getAll", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/GetAllReportInstancesResponse;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/GetAllReportInstancesRequest;", "getRetryAfterTime", "", "info", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/GetReportInstanceResponse;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/GetReportInstanceRequest;", "poll", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/PollReportInstanceResponse;", "update", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/UpdateReportInstanceStatusResponse;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/UpdateReportInstanceStatusRequest;", "opendistro-reports-scheduler"})
public final class ReportInstanceActions {
    private static final Lazy log$delegate;
    public static final ReportInstanceActions INSTANCE;

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        ReportInstanceActions reportInstanceActions = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final InContextReportCreateResponse createOnDemand(@NotNull InContextReportCreateRequest request, @Nullable User user) {
        Instant currentTime;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-createOnDemand");
        UserAccessManager.INSTANCE.validateUser(user);
        Instant instant = currentTime = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"currentTime");
        ReportInstance reportInstance = new ReportInstance("ignore", instant, currentTime, request.getBeginTime(), request.getEndTime(), UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getAllAccessInfo(user), request.getReportDefinitionDetails(), ReportInstance.Status.Success, request.getStatusText(), request.getInContextDownloadUrlPath());
        String docId = ReportInstancesIndex.INSTANCE.createReportInstance(reportInstance);
        if (docId == null) {
            ReportInstanceActions reportInstanceActions = this;
            boolean bl = false;
            boolean bl2 = false;
            ReportInstanceActions $this$run = reportInstanceActions;
            boolean bl3 = false;
            Metrics.REPORT_FROM_DEFINITION_SYSTEM_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Instance Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        ReportInstance reportInstanceCopy = ReportInstance.copy$default(reportInstance, docId, null, null, null, null, null, null, null, null, null, null, 2046, null);
        return new InContextReportCreateResponse(reportInstanceCopy, UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    @NotNull
    public final OnDemandReportCreateResponse createOnDemandFromDefinition(@NotNull OnDemandReportCreateRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-createOnDemandFromDefinition " + request.getReportDefinitionId());
        UserAccessManager.INSTANCE.validateUser(user);
        Instant currentTime = Instant.now();
        ReportDefinitionDetails reportDefinitionDetails = ReportDefinitionsIndex.INSTANCE.getReportDefinition(request.getReportDefinitionId());
        if (reportDefinitionDetails == null) {
            ReportInstanceActions reportInstanceActions = this;
            boolean bl = false;
            boolean bl2 = false;
            ReportInstanceActions $this$run = reportInstanceActions;
            boolean bl3 = false;
            Metrics.REPORT_DEFINITION_INFO_USER_ERROR_MISSING_REPORT_DEF_DETAILS.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Definition " + request.getReportDefinitionId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, reportDefinitionDetails.getTenant(), reportDefinitionDetails.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Permission denied for Report Definition " + request.getReportDefinitionId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        Instant instant = currentTime.minus(reportDefinitionDetails.getReportDefinition().getFormat().getDuration());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"currentTime.minus(report\u2026finition.format.duration)");
        Instant beginTime = instant;
        Instant instant2 = currentTime;
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"currentTime");
        Instant endTime = instant2;
        ReportInstance.Status currentStatus = ReportInstance.Status.Success;
        ReportInstance reportInstance = new ReportInstance("ignore", currentTime, currentTime, beginTime, endTime, UserAccessManager.INSTANCE.getUserTenant(user), reportDefinitionDetails.getAccess(), reportDefinitionDetails, currentStatus, null, null, 1536, null);
        String docId = ReportInstancesIndex.INSTANCE.createReportInstance(reportInstance);
        if (docId == null) {
            ReportInstanceActions reportInstanceActions = this;
            boolean bl = false;
            boolean bl4 = false;
            ReportInstanceActions $this$run = reportInstanceActions;
            boolean bl5 = false;
            Metrics.REPORT_FROM_DEFINITION_ID_SYSTEM_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Instance Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        ReportInstance reportInstanceCopy = ReportInstance.copy$default(reportInstance, docId, null, null, null, null, null, null, null, null, null, null, 2046, null);
        return new OnDemandReportCreateResponse(reportInstanceCopy, UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    @NotNull
    public final UpdateReportInstanceStatusResponse update(@NotNull UpdateReportInstanceStatusRequest request, @Nullable User user) {
        Instant currentTime;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-update " + request.getReportInstanceId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportInstance currentReportInstance = ReportInstancesIndex.INSTANCE.getReportInstance(request.getReportInstanceId());
        if (currentReportInstance == null) {
            ReportInstanceActions reportInstanceActions = this;
            boolean bl = false;
            boolean bl2 = false;
            ReportInstanceActions $this$run = reportInstanceActions;
            boolean bl3 = false;
            Metrics.REPORT_INSTANCE_UPDATE_USER_ERROR_MISSING_REPORT_INSTANCE.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Instance " + request.getReportInstanceId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, currentReportInstance.getTenant(), currentReportInstance.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Permission denied for Report Definition " + request.getReportInstanceId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        if (request.getStatus() == ReportInstance.Status.Scheduled) {
            Metrics.REPORT_INSTANCE_UPDATE_USER_ERROR_INVALID_STATUS.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Status cannot be updated to " + (Object)((Object)ReportInstance.Status.Scheduled), RestStatus.BAD_REQUEST, new Object[0]);
        }
        Instant instant = currentTime = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"currentTime");
        ReportInstance updatedReportInstance = ReportInstance.copy$default(currentReportInstance, null, instant, null, null, null, null, null, null, request.getStatus(), request.getStatusText(), null, 1277, null);
        if (!ReportInstancesIndex.INSTANCE.updateReportInstance(updatedReportInstance)) {
            Metrics.REPORT_INSTANCE_UPDATE_SYSTEM_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Instance state update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new UpdateReportInstanceStatusResponse(request.getReportInstanceId());
    }

    @NotNull
    public final GetReportInstanceResponse info(@NotNull GetReportInstanceRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-info " + request.getReportInstanceId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportInstance reportInstance = ReportInstancesIndex.INSTANCE.getReportInstance(request.getReportInstanceId());
        if (reportInstance == null) {
            ReportInstanceActions reportInstanceActions = this;
            boolean bl = false;
            boolean bl2 = false;
            ReportInstanceActions $this$run = reportInstanceActions;
            boolean bl3 = false;
            Metrics.REPORT_INSTANCE_INFO_USER_ERROR_MISSING_REPORT_INSTANCE.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Instance " + request.getReportInstanceId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, reportInstance.getTenant(), reportInstance.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Permission denied for Report Definition " + request.getReportInstanceId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        return new GetReportInstanceResponse(reportInstance, UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    @NotNull
    public final GetAllReportInstancesResponse getAll(@NotNull GetAllReportInstancesRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportInstance-getAll fromIndex:" + request.getFromIndex() + " maxItems:" + request.getMaxItems());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportInstanceSearchResults reportInstanceList = ReportInstancesIndex.INSTANCE.getAllReportInstances(UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getSearchAccessInfo(user), request.getFromIndex(), request.getMaxItems());
        return new GetAllReportInstancesResponse(reportInstanceList, UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    @NotNull
    public final PollReportInstanceResponse poll(@Nullable User user) {
        PollReportInstanceResponse pollReportInstanceResponse;
        this.getLog().info("reports:ReportInstance-poll");
        UserAccessManager.INSTANCE.validatePollingUser(user);
        Instant currentTime = Instant.now();
        List<ReportInstanceDoc> reportInstances = ReportInstancesIndex.INSTANCE.getPendingReportInstances();
        if (reportInstances.isEmpty()) {
            pollReportInstanceResponse = new PollReportInstanceResponse(this.getRetryAfterTime(), null, false, 6, null);
        } else {
            Object v3;
            block3: {
                List<ReportInstanceDoc> list = reportInstances;
                boolean bl = false;
                Collections.shuffle(list);
                Iterable iterable = reportInstances.subList(0, PluginSettings.INSTANCE.getMaxLockRetries());
                boolean bl2 = false;
                Iterable iterable2 = iterable;
                boolean bl3 = false;
                for (Object t : iterable2) {
                    ReportInstanceDoc it = (ReportInstanceDoc)t;
                    boolean bl4 = false;
                    ReportInstance reportInstance = it.getReportInstance();
                    Instant instant = currentTime;
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"currentTime");
                    ReportInstanceDoc updatedInstance = ReportInstanceDoc.copy$default(it, ReportInstance.copy$default(reportInstance, null, instant, null, null, null, null, null, null, ReportInstance.Status.Executing, null, null, 1789, null), 0L, 0L, 6, null);
                    if (!ReportInstancesIndex.INSTANCE.updateReportInstanceDoc(updatedInstance)) continue;
                    v3 = t;
                    break block3;
                }
                v3 = null;
            }
            ReportInstanceDoc lockedJob = v3;
            pollReportInstanceResponse = lockedJob == null ? new PollReportInstanceResponse(PluginSettings.INSTANCE.getMinPollingDurationSeconds(), null, false, 6, null) : new PollReportInstanceResponse(0, lockedJob.getReportInstance(), UserAccessManager.INSTANCE.hasAllInfoAccess(user));
        }
        return pollReportInstanceResponse;
    }

    private final int getRetryAfterTime() {
        return Random.Default.nextInt(PluginSettings.INSTANCE.getMinPollingDurationSeconds(), PluginSettings.INSTANCE.getMaxPollingDurationSeconds());
    }

    private ReportInstanceActions() {
    }

    static {
        ReportInstanceActions reportInstanceActions;
        INSTANCE = reportInstanceActions = new ReportInstanceActions();
        log$delegate = HelpersKt.logger(ReportInstanceActions.class);
    }
}

