/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.reportsscheduler.action;

import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import com.amazon.opendistroforelasticsearch.reportsscheduler.index.ReportDefinitionsIndex;
import com.amazon.opendistroforelasticsearch.reportsscheduler.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.CreateReportDefinitionRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.CreateReportDefinitionResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.DeleteReportDefinitionRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.DeleteReportDefinitionResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetAllReportDefinitionsRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetAllReportDefinitionsResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetReportDefinitionRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.GetReportDefinitionResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportDefinitionDetails;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.ReportDefinitionDetailsSearchResults;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.UpdateReportDefinitionRequest;
import com.amazon.opendistroforelasticsearch.reportsscheduler.model.UpdateReportDefinitionResponse;
import com.amazon.opendistroforelasticsearch.reportsscheduler.security.UserAccessManager;
import com.amazon.opendistroforelasticsearch.reportsscheduler.util.HelpersKt;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/amazon/opendistroforelasticsearch/reportsscheduler/action/ReportDefinitionActions;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "create", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/CreateReportDefinitionResponse;", "request", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/CreateReportDefinitionRequest;", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "delete", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/DeleteReportDefinitionResponse;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/DeleteReportDefinitionRequest;", "getAll", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/GetAllReportDefinitionsResponse;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/GetAllReportDefinitionsRequest;", "info", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/GetReportDefinitionResponse;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/GetReportDefinitionRequest;", "update", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/UpdateReportDefinitionResponse;", "Lcom/amazon/opendistroforelasticsearch/reportsscheduler/model/UpdateReportDefinitionRequest;", "opendistro-reports-scheduler"})
public final class ReportDefinitionActions {
    private static final Lazy log$delegate;
    public static final ReportDefinitionActions INSTANCE;

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        ReportDefinitionActions reportDefinitionActions = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final CreateReportDefinitionResponse create(@NotNull CreateReportDefinitionRequest request, @Nullable User user) {
        Instant currentTime;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-create");
        UserAccessManager.INSTANCE.validateUser(user);
        Instant instant = currentTime = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"currentTime");
        ReportDefinitionDetails reportDefinitionDetails = new ReportDefinitionDetails("ignore", instant, currentTime, UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getAllAccessInfo(user), request.getReportDefinition());
        String docId = ReportDefinitionsIndex.INSTANCE.createReportDefinition(reportDefinitionDetails);
        if (docId == null) {
            throw (Throwable)new ElasticsearchStatusException("Report Definition Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new CreateReportDefinitionResponse(docId);
    }

    @NotNull
    public final UpdateReportDefinitionResponse update(@NotNull UpdateReportDefinitionRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-update " + request.getReportDefinitionId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportDefinitionDetails currentReportDefinitionDetails = ReportDefinitionsIndex.INSTANCE.getReportDefinition(request.getReportDefinitionId());
        if (currentReportDefinitionDetails == null) {
            ReportDefinitionActions reportDefinitionActions = this;
            boolean bl = false;
            boolean bl2 = false;
            ReportDefinitionActions $this$run = reportDefinitionActions;
            boolean bl3 = false;
            Metrics.REPORT_DEFINITION_UPDATE_USER_ERROR_MISSING_REPORT_DEF_DETAILS.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Definition " + request.getReportDefinitionId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, currentReportDefinitionDetails.getTenant(), currentReportDefinitionDetails.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Permission denied for Report Definition " + request.getReportDefinitionId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        Instant currentTime = Instant.now();
        String string = request.getReportDefinitionId();
        Instant instant = currentTime;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"currentTime");
        ReportDefinitionDetails reportDefinitionDetails = new ReportDefinitionDetails(string, instant, currentReportDefinitionDetails.getCreatedTime(), UserAccessManager.INSTANCE.getUserTenant(user), currentReportDefinitionDetails.getAccess(), request.getReportDefinition());
        if (!ReportDefinitionsIndex.INSTANCE.updateReportDefinition(request.getReportDefinitionId(), reportDefinitionDetails)) {
            Metrics.REPORT_DEFINITION_UPDATE_SYSTEM_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Definition Update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new UpdateReportDefinitionResponse(request.getReportDefinitionId());
    }

    @NotNull
    public final GetReportDefinitionResponse info(@NotNull GetReportDefinitionRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-info " + request.getReportDefinitionId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportDefinitionDetails reportDefinitionDetails = ReportDefinitionsIndex.INSTANCE.getReportDefinition(request.getReportDefinitionId());
        if (reportDefinitionDetails == null) {
            ReportDefinitionActions reportDefinitionActions = this;
            boolean bl = false;
            boolean bl2 = false;
            ReportDefinitionActions $this$run = reportDefinitionActions;
            boolean bl3 = false;
            Metrics.REPORT_DEFINITION_INFO_SYSTEM_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Definition " + request.getReportDefinitionId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, reportDefinitionDetails.getTenant(), reportDefinitionDetails.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Permission denied for Report Definition " + request.getReportDefinitionId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        return new GetReportDefinitionResponse(reportDefinitionDetails, UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    @NotNull
    public final DeleteReportDefinitionResponse delete(@NotNull DeleteReportDefinitionRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-delete " + request.getReportDefinitionId());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportDefinitionDetails reportDefinitionDetails = ReportDefinitionsIndex.INSTANCE.getReportDefinition(request.getReportDefinitionId());
        if (reportDefinitionDetails == null) {
            ReportDefinitionActions reportDefinitionActions = this;
            boolean bl = false;
            boolean bl2 = false;
            ReportDefinitionActions $this$run = reportDefinitionActions;
            boolean bl3 = false;
            Metrics.REPORT_DEFINITION_DELETE_USER_ERROR_MISSING_REPORT_DEF_DETAILS.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Definition " + request.getReportDefinitionId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, reportDefinitionDetails.getTenant(), reportDefinitionDetails.getAccess())) {
            Metrics.REPORT_PERMISSION_USER_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Permission denied for Report Definition " + request.getReportDefinitionId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        if (!ReportDefinitionsIndex.INSTANCE.deleteReportDefinition(request.getReportDefinitionId())) {
            Metrics.REPORT_DEFINITION_DELETE_SYSTEM_ERROR.getCounter().increment();
            throw (Throwable)new ElasticsearchStatusException("Report Definition " + request.getReportDefinitionId() + " delete failed", RestStatus.REQUEST_TIMEOUT, new Object[0]);
        }
        return new DeleteReportDefinitionResponse(request.getReportDefinitionId());
    }

    @NotNull
    public final GetAllReportDefinitionsResponse getAll(@NotNull GetAllReportDefinitionsRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("reports:ReportDefinition-getAll fromIndex:" + request.getFromIndex() + " maxItems:" + request.getMaxItems());
        UserAccessManager.INSTANCE.validateUser(user);
        ReportDefinitionDetailsSearchResults reportDefinitionsList = ReportDefinitionsIndex.INSTANCE.getAllReportDefinitions(UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getSearchAccessInfo(user), request.getFromIndex(), request.getMaxItems());
        return new GetAllReportDefinitionsResponse(reportDefinitionsList, UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    private ReportDefinitionActions() {
    }

    static {
        ReportDefinitionActions reportDefinitionActions;
        INSTANCE = reportDefinitionActions = new ReportDefinitionActions();
        log$delegate = HelpersKt.logger(ReportDefinitionActions.class);
    }
}

