/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.plugin.stats;

import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNStat;
import java.util.HashMap;
import java.util.Map;

public class KNNStats {
    private Map<String, KNNStat<?>> knnStats;

    public KNNStats(Map<String, KNNStat<?>> knnStats) {
        this.knnStats = knnStats;
    }

    public Map<String, KNNStat<?>> getStats() {
        return this.knnStats;
    }

    public KNNStat<?> getStat(String key) throws IllegalArgumentException {
        if (!this.knnStats.keySet().contains(key)) {
            throw new IllegalArgumentException("Stat=\"" + key + "\" does not exist");
        }
        return this.knnStats.get(key);
    }

    public Map<String, KNNStat<?>> getNodeStats() {
        return this.getClusterOrNodeStats(false);
    }

    public Map<String, KNNStat<?>> getClusterStats() {
        return this.getClusterOrNodeStats(true);
    }

    private Map<String, KNNStat<?>> getClusterOrNodeStats(Boolean getClusterStats) {
        HashMap statsMap = new HashMap();
        for (Map.Entry<String, KNNStat<?>> entry : this.knnStats.entrySet()) {
            if (entry.getValue().isClusterLevel() != getClusterStats) continue;
            statsMap.put(entry.getKey(), entry.getValue());
        }
        return statsMap;
    }
}

