/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.plugin.script;

import com.amazon.opendistroforelasticsearch.knn.index.KNNVectorFieldMapper;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNCounter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;

public class KNNScoringSpaceUtil {
    public static boolean isLongFieldType(MappedFieldType fieldType) {
        return fieldType instanceof NumberFieldMapper.NumberFieldType && ((NumberFieldMapper.NumberFieldType)fieldType).numericType() == NumberFieldMapper.NumberType.LONG.numericType();
    }

    public static boolean isBinaryFieldType(MappedFieldType fieldType) {
        return fieldType instanceof BinaryFieldMapper.BinaryFieldType;
    }

    public static boolean isKNNVectorFieldType(MappedFieldType fieldType) {
        return fieldType instanceof KNNVectorFieldMapper.KNNVectorFieldType;
    }

    public static Long parseToLong(Object object) {
        if (object instanceof Integer) {
            return (long)((Integer)object);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new IllegalArgumentException("Object cannot be parsed as a Long.");
    }

    public static BigInteger parseToBigInteger(Object object) {
        return new BigInteger(1, Base64.getDecoder().decode((String)object));
    }

    public static float[] parseToFloatArray(Object object, int expectedDimensions) {
        float[] floatArray = KNNScoringSpaceUtil.convertVectorToPrimitive(object);
        if (expectedDimensions != floatArray.length) {
            KNNCounter.SCRIPT_QUERY_ERRORS.increment();
            throw new IllegalStateException("Object's dimension=" + floatArray.length + " does not match the expected dimension=" + expectedDimensions + ".");
        }
        return floatArray;
    }

    public static float[] convertVectorToPrimitive(Object vector) {
        float[] primitiveVector = null;
        if (vector != null) {
            ArrayList tmp = (ArrayList)vector;
            primitiveVector = new float[tmp.size()];
            for (int i = 0; i < primitiveVector.length; ++i) {
                primitiveVector[i] = ((Double)tmp.get(i)).floatValue();
            }
        }
        return primitiveVector;
    }

    public static float getVectorMagnitudeSquared(float[] inputVector) {
        if (null == inputVector) {
            throw new IllegalStateException("vector magnitude cannot be evaluated as it is null");
        }
        float normInputVector = 0.0f;
        for (int i = 0; i < inputVector.length; ++i) {
            normInputVector += inputVector[i] * inputVector[i];
        }
        return normInputVector;
    }
}

