/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.plugin.script;

import com.amazon.opendistroforelasticsearch.knn.plugin.script.KNNScoringSpace;
import com.amazon.opendistroforelasticsearch.knn.plugin.script.KNNScoringSpaceFactory;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNCounter;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.search.lookup.SearchLookup;

public class KNNScoreScriptFactory
implements ScoreScript.LeafFactory {
    private final Map<String, Object> params;
    private final SearchLookup lookup;
    private String similaritySpace;
    private String field;
    private Object query;
    private KNNScoringSpace knnScoringSpace;

    public KNNScoreScriptFactory(Map<String, Object> params, SearchLookup lookup) {
        KNNCounter.SCRIPT_QUERY_REQUESTS.increment();
        this.params = params;
        this.lookup = lookup;
        this.field = this.getValue(params, "field").toString();
        this.similaritySpace = this.getValue(params, "space_type").toString();
        this.query = this.getValue(params, "query_value");
        this.knnScoringSpace = KNNScoringSpaceFactory.create(this.similaritySpace, this.query, lookup.doc().mapperService().fieldType(this.field));
    }

    private Object getValue(Map<String, Object> params, String fieldName) {
        Object value = params.get(fieldName);
        if (value != null) {
            return value;
        }
        KNNCounter.SCRIPT_QUERY_ERRORS.increment();
        throw new IllegalArgumentException("Missing parameter [" + fieldName + "]");
    }

    public boolean needs_score() {
        return false;
    }

    public ScoreScript newInstance(LeafReaderContext ctx) throws IOException {
        return this.knnScoringSpace.getScoreScript(this.params, this.field, this.lookup, ctx);
    }
}

