/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.plugin.script;

import com.amazon.opendistroforelasticsearch.knn.index.KNNVectorScriptDocValues;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class KNNScoreScript<T>
extends ScoreScript {
    protected final T queryValue;
    protected final String field;
    protected final BiFunction<T, T, Float> scoringMethod;

    public KNNScoreScript(Map<String, Object> params, T queryValue, String field, BiFunction<T, T, Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext) {
        super(params, lookup, leafContext);
        this.queryValue = queryValue;
        this.field = field;
        this.scoringMethod = scoringMethod;
    }

    public static class KNNVectorType
    extends KNNScoreScript<float[]> {
        public KNNVectorType(Map<String, Object> params, float[] queryValue, String field, BiFunction<float[], float[], Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext) throws IOException {
            super(params, queryValue, field, scoringMethod, lookup, leafContext);
        }

        public double execute(ScoreScript.ExplanationHolder explanationHolder) {
            KNNVectorScriptDocValues scriptDocValues = (KNNVectorScriptDocValues)((Object)this.getDoc().get(this.field));
            if (scriptDocValues.isEmpty()) {
                return 1.4E-45f;
            }
            return ((Float)this.scoringMethod.apply((float[])this.queryValue, scriptDocValues.getValue())).floatValue();
        }
    }

    public static class BigIntegerType
    extends KNNScoreScript<BigInteger> {
        public BigIntegerType(Map<String, Object> params, BigInteger queryValue, String field, BiFunction<BigInteger, BigInteger, Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext) {
            super(params, queryValue, field, scoringMethod, lookup, leafContext);
        }

        public double execute(ScoreScript.ExplanationHolder explanationHolder) {
            ScriptDocValues.BytesRefs scriptDocValues = (ScriptDocValues.BytesRefs)this.getDoc().get(this.field);
            if (scriptDocValues.isEmpty()) {
                return 1.4E-45f;
            }
            return ((Float)this.scoringMethod.apply((BigInteger)this.queryValue, new BigInteger(1, scriptDocValues.getValue().bytes))).floatValue();
        }
    }

    public static class LongType
    extends KNNScoreScript<Long> {
        public LongType(Map<String, Object> params, Long queryValue, String field, BiFunction<Long, Long, Float> scoringMethod, SearchLookup lookup, LeafReaderContext leafContext) {
            super(params, queryValue, field, scoringMethod, lookup, leafContext);
        }

        public double execute(ScoreScript.ExplanationHolder explanationHolder) {
            ScriptDocValues.Longs scriptDocValues = (ScriptDocValues.Longs)this.getDoc().get(this.field);
            if (scriptDocValues.isEmpty()) {
                return 1.4E-45f;
            }
            return ((Float)this.scoringMethod.apply((Long)this.queryValue, scriptDocValues.getValue())).floatValue();
        }
    }
}

