/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.plugin.rest;

import com.amazon.opendistroforelasticsearch.knn.common.exception.KNNInvalidIndicesException;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNWarmupAction;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNWarmupRequest;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestKNNWarmupHandler
extends BaseRestHandler {
    public static String NAME = "knn_warmup_action";
    private static final Logger logger = LogManager.getLogger(RestKNNWarmupHandler.class);
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private ClusterService clusterService;

    public RestKNNWarmupHandler(Settings settings, RestController controller, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_knn/warmup/{index}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        KNNWarmupRequest knnWarmupRequest = this.createKNNWarmupRequest(request);
        logger.info("[KNN] Warmup started for the following indices: " + String.join((CharSequence)",", knnWarmupRequest.indices()));
        return channel -> client.execute((ActionType)KNNWarmupAction.INSTANCE, (ActionRequest)knnWarmupRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private KNNWarmupRequest createKNNWarmupRequest(RestRequest request) {
        String[] indexNames = Strings.splitStringByCommaToArray((String)request.param("index"));
        Index[] indices = this.indexNameExpressionResolver.concreteIndices(this.clusterService.state(), IndicesOptions.strictExpandOpen(), indexNames);
        ArrayList<String> invalidIndexNames = new ArrayList<String>();
        Arrays.stream(indices).forEach(index -> {
            if (!"true".equals(this.clusterService.state().metadata().getIndexSafe(index).getSettings().get("index.knn"))) {
                invalidIndexNames.add(index.getName());
            }
        });
        if (invalidIndexNames.size() != 0) {
            throw new KNNInvalidIndicesException(invalidIndexNames, "Warm up request rejected. One or more indices have 'index.knn' set to false.");
        }
        return new KNNWarmupRequest(indexNames);
    }
}

