/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.plugin.rest;

import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNStats;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNStatsAction;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNStatsRequest;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;

public class RestKNNStatsHandler
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestKNNStatsHandler.class);
    private static final String NAME = "knn_stats_action";
    private KNNStats knnStats;

    public RestKNNStatsHandler(Settings settings, RestController controller, KNNStats knnStats) {
        this.knnStats = knnStats;
    }

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_knn/{nodeId}/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_knn/{nodeId}/stats/{stat}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_knn/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_knn/stats/{stat}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        KNNStatsRequest knnStatsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)KNNStatsAction.INSTANCE, (ActionRequest)knnStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    private KNNStatsRequest getRequest(RestRequest request) {
        String[] nodeIdsArr = null;
        String nodesIdsStr = request.param("nodeId");
        if (!Strings.isEmpty((CharSequence)nodesIdsStr)) {
            nodeIdsArr = nodesIdsStr.split(",");
        }
        KNNStatsRequest knnStatsRequest = new KNNStatsRequest(this.knnStats.getStats().keySet(), nodeIdsArr);
        knnStatsRequest.timeout(request.param("timeout"));
        HashSet<String> statsSet = null;
        String statsStr = request.param("stat");
        if (!Strings.isEmpty((CharSequence)statsStr)) {
            statsSet = new HashSet<String>(Arrays.asList(statsStr.split(",")));
        }
        if (statsSet == null) {
            knnStatsRequest.all();
        } else if (statsSet.size() == 1 && statsSet.contains("_all")) {
            knnStatsRequest.all();
        } else {
            if (statsSet.contains("_all")) {
                throw new IllegalArgumentException("Request " + request.path() + " contains _all and individual stats");
            }
            TreeSet<String> invalidStats = new TreeSet<String>();
            for (String stat : statsSet) {
                if (knnStatsRequest.addStat(stat)) continue;
                invalidStats.add(stat);
            }
            if (!invalidStats.isEmpty()) {
                throw new IllegalArgumentException(this.unrecognized(request, invalidStats, knnStatsRequest.getStatsToBeRetrieved(), "stat"));
            }
        }
        return knnStatsRequest;
    }
}

