/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.plugin;

import com.amazon.opendistroforelasticsearch.knn.index.KNNCircuitBreaker;
import com.amazon.opendistroforelasticsearch.knn.index.KNNIndexCache;
import com.amazon.opendistroforelasticsearch.knn.index.KNNQueryBuilder;
import com.amazon.opendistroforelasticsearch.knn.index.KNNSettings;
import com.amazon.opendistroforelasticsearch.knn.index.KNNVectorFieldMapper;
import com.amazon.opendistroforelasticsearch.knn.plugin.KNNEngineFactory;
import com.amazon.opendistroforelasticsearch.knn.plugin.rest.RestKNNStatsHandler;
import com.amazon.opendistroforelasticsearch.knn.plugin.rest.RestKNNWarmupHandler;
import com.amazon.opendistroforelasticsearch.knn.plugin.script.KNNScoringScriptEngine;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNStats;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNStatsConfig;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNStatsAction;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNStatsTransportAction;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNWarmupAction;
import com.amazon.opendistroforelasticsearch.knn.plugin.transport.KNNWarmupTransportAction;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;

public class KNNPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin,
ActionPlugin,
EnginePlugin,
ScriptPlugin {
    public static final String KNN_BASE_URI = "/_opendistro/_knn";
    private KNNStats knnStats;
    private ClusterService clusterService;

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("knn_vector", new KNNVectorFieldMapper.TypeParser());
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("knn", KNNQueryBuilder::new, KNNQueryBuilder::fromXContent));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.clusterService = clusterService;
        KNNIndexCache.setResourceWatcherService(resourceWatcherService);
        KNNSettings.state().initialize(client, clusterService);
        KNNCircuitBreaker.getInstance().initialize(threadPool, clusterService, client);
        this.knnStats = new KNNStats(KNNStatsConfig.KNN_STATS);
        return ImmutableList.of((Object)this.knnStats);
    }

    public List<Setting<?>> getSettings() {
        return KNNSettings.state().getSettings();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestKNNStatsHandler restKNNStatsHandler = new RestKNNStatsHandler(settings, restController, this.knnStats);
        RestKNNWarmupHandler restKNNWarmupHandler = new RestKNNWarmupHandler(settings, restController, this.clusterService, indexNameExpressionResolver);
        return Arrays.asList(new RestHandler[]{restKNNStatsHandler, restKNNWarmupHandler});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)KNNStatsAction.INSTANCE, KNNStatsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)KNNWarmupAction.INSTANCE, KNNWarmupTransportAction.class, new Class[0]));
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (((Boolean)indexSettings.getValue(KNNSettings.IS_KNN_INDEX_SETTING)).booleanValue()) {
            return Optional.of(new KNNEngineFactory());
        }
        return Optional.empty();
    }

    public void onIndexModule(IndexModule indexModule) {
        KNNSettings.state().onIndexModule(indexModule);
    }

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new KNNScoringScriptEngine();
    }
}

