/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index.v2011;

import com.amazon.opendistroforelasticsearch.knn.index.KNNQueryResult;
import com.amazon.opendistroforelasticsearch.knn.index.util.NmsLibVersion;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNCounter;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class KNNIndex
implements AutoCloseable {
    public static NmsLibVersion VERSION = NmsLibVersion.V2011;
    private volatile boolean isClosed = false;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final long indexPointer;
    private final long indexSize;

    private KNNIndex(long indexPointer, long indexSize) {
        this.indexPointer = indexPointer;
        this.indexSize = indexSize;
    }

    public long getIndexSize() {
        return this.indexSize;
    }

    public KNNQueryResult[] queryIndex(final float[] query, final int k) throws IOException {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        KNNCounter.GRAPH_QUERY_REQUESTS.increment();
        try {
            if (this.isClosed) {
                throw new IOException("Index is already closed");
            }
            final long indexPointer = this.indexPointer;
            KNNQueryResult[] kNNQueryResultArray = AccessController.doPrivileged(new PrivilegedAction<KNNQueryResult[]>(){

                @Override
                public KNNQueryResult[] run() {
                    return KNNIndex.queryIndex(indexPointer, query, k);
                }
            });
            return kNNQueryResultArray;
        }
        catch (Exception ex) {
            KNNCounter.GRAPH_QUERY_ERRORS.increment();
            throw new RuntimeException("Unable to query the index: " + ex);
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void close() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        if (this.isClosed) {
            return;
        }
        try {
            KNNIndex.gc(this.indexPointer);
        }
        finally {
            this.isClosed = true;
            writeLock.unlock();
        }
    }

    public static KNNIndex loadIndex(String indexPath, String[] algoParams, String spaceType) {
        long fileSize = KNNIndex.computeFileSize(indexPath);
        long indexPointer = KNNIndex.init(indexPath, algoParams, spaceType);
        return new KNNIndex(indexPointer, fileSize);
    }

    private static long computeFileSize(String indexPath) {
        if (indexPath == null || indexPath.isEmpty()) {
            return 0L;
        }
        File file = new File(indexPath);
        if (!file.exists() || !file.isFile()) {
            return 0L;
        }
        return file.length() / 1024L + 1L;
    }

    public static native void saveIndex(int[] var0, float[][] var1, String var2, String[] var3, String var4);

    private static native KNNQueryResult[] queryIndex(long var0, float[] var2, int var3);

    private static native long init(String var0, String[] var1, String var2);

    private static native void gc(long var0);

    private static native void initLibrary();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary(NmsLibVersion.LATEST.indexLibraryVersion());
                return null;
            }
        });
        KNNIndex.initLibrary();
    }
}

