/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index.codec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;

public class KNNCodecUtil {
    public static final String HNSW_EXTENSION = ".hnsw";
    public static final String HNSW_COMPOUND_EXTENSION = ".hnswc";

    public static Pair getFloats(BinaryDocValues values) throws IOException {
        ArrayList<float[]> vectorList = new ArrayList<float[]>();
        ArrayList<Integer> docIdList = new ArrayList<Integer>();
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            BytesRef bytesref = values.binaryValue();
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytesref.bytes, bytesref.offset, bytesref.length);
                 ObjectInputStream objectStream = new ObjectInputStream(byteStream);){
                float[] vector = (float[])objectStream.readObject();
                vectorList.add(vector);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            docIdList.add(doc);
            doc = values.nextDoc();
        }
        return new Pair(docIdList.stream().mapToInt(Integer::intValue).toArray(), (float[][])vectorList.toArray((T[])new float[0][]));
    }

    public static final class Pair {
        public int[] docs;
        public float[][] vectors;

        public Pair(int[] docs, float[][] vectors) {
            this.docs = docs;
            this.vectors = vectors;
        }
    }
}

