/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index.codec.KNN80Codec;

import com.amazon.opendistroforelasticsearch.knn.index.codec.BinaryDocValuesSub;
import com.amazon.opendistroforelasticsearch.knn.index.codec.KNN80Codec.KNN80BinaryDocValues;
import java.util.ArrayList;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;

class KNN80DocValuesReader
extends EmptyDocValuesProducer {
    private MergeState mergeState;

    KNN80DocValuesReader(MergeState mergeState) {
        this.mergeState = mergeState;
    }

    public BinaryDocValues getBinary(FieldInfo field) {
        try {
            ArrayList<BinaryDocValuesSub> subs = new ArrayList<BinaryDocValuesSub>(this.mergeState.docValuesProducers.length);
            for (int i = 0; i < this.mergeState.docValuesProducers.length; ++i) {
                BinaryDocValues values = null;
                DocValuesProducer docValuesProducer = this.mergeState.docValuesProducers[i];
                if (docValuesProducer == null) continue;
                FieldInfo readerFieldInfo = this.mergeState.fieldInfos[i].fieldInfo(field.name);
                if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                    values = docValuesProducer.getBinary(readerFieldInfo);
                }
                if (values == null) continue;
                subs.add(new BinaryDocValuesSub(this.mergeState.docMaps[i], values));
            }
            return new KNN80BinaryDocValues((DocIDMerger<BinaryDocValuesSub>)DocIDMerger.of(subs, (boolean)this.mergeState.needsIndexSort));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

