/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index.codec.KNN80Codec;

import com.amazon.opendistroforelasticsearch.knn.index.KNNSettings;
import com.amazon.opendistroforelasticsearch.knn.index.SpaceTypes;
import com.amazon.opendistroforelasticsearch.knn.index.codec.KNN80Codec.KNN80DocValuesReader;
import com.amazon.opendistroforelasticsearch.knn.index.codec.KNNCodecUtil;
import com.amazon.opendistroforelasticsearch.knn.index.util.NmsLibVersion;
import com.amazon.opendistroforelasticsearch.knn.index.v2011.KNNIndex;
import com.amazon.opendistroforelasticsearch.knn.plugin.stats.KNNCounter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

class KNN80DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    private final Logger logger = LogManager.getLogger(KNN80DocValuesConsumer.class);
    private final String TEMP_SUFFIX = "tmp";
    private DocValuesConsumer delegatee;
    private SegmentWriteState state;

    KNN80DocValuesConsumer(DocValuesConsumer delegatee, SegmentWriteState state) throws IOException {
        this.delegatee = delegatee;
        this.state = state;
    }

    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addBinaryField(field, valuesProducer);
        this.addKNNBinaryField(field, valuesProducer);
    }

    public void addKNNBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        KNNCounter.GRAPH_INDEX_REQUESTS.increment();
        if (field.attributes().containsKey("knn_field")) {
            if (!this.isNmsLibLatest()) {
                KNNCounter.GRAPH_INDEX_ERRORS.increment();
                throw new IllegalStateException("Nms library version mismatch. Correct version: " + NmsLibVersion.LATEST.indexLibraryVersion());
            }
            BinaryDocValues values = valuesProducer.getBinary(field);
            String hnswFileName = String.format("%s_%s_%s%s", this.state.segmentInfo.name, NmsLibVersion.LATEST.buildVersion, field.name, ".hnsw");
            String indexPath = Paths.get(((FSDirectory)FilterDirectory.unwrap((Directory)this.state.directory)).getDirectory().toString(), hnswFileName).toString();
            final KNNCodecUtil.Pair pair = KNNCodecUtil.getFloats(values);
            if (pair == null || pair.vectors.length == 0 || pair.docs.length == 0) {
                this.logger.info("Skipping hnsw index creation as there are no vectors or docs in the documents");
                return;
            }
            final String tempIndexPath = indexPath + "tmp";
            Map fieldAttributes = field.attributes();
            final String spaceType = fieldAttributes.getOrDefault("spaceType", SpaceTypes.l2.getValue());
            final String[] algoParams = this.getKNNIndexParams(fieldAttributes);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    KNNIndex.saveIndex(pair.docs, pair.vectors, tempIndexPath, algoParams, spaceType);
                    return null;
                }
            });
            String hsnwTempFileName = hnswFileName + "tmp";
            try (IndexInput is = this.state.directory.openInput(hsnwTempFileName, this.state.context);
                 IndexOutput os = this.state.directory.createOutput(hnswFileName, this.state.context);){
                os.copyBytes((DataInput)is, is.length());
                CodecUtil.writeFooter((IndexOutput)os);
            }
            catch (Exception ex) {
                try {
                    KNNCounter.GRAPH_INDEX_ERRORS.increment();
                    throw new RuntimeException("[KNN] Adding footer to serialized graph failed: " + ex);
                }
                catch (Throwable throwable) {
                    IOUtils.deleteFilesIgnoringExceptions((Directory)this.state.directory, (String[])new String[]{hsnwTempFileName});
                    throw throwable;
                }
            }
            IOUtils.deleteFilesIgnoringExceptions((Directory)this.state.directory, (String[])new String[]{hsnwTempFileName});
        }
    }

    public void merge(MergeState mergeState) {
        try {
            this.delegatee.merge(mergeState);
            assert (mergeState != null);
            assert (mergeState.mergeFieldInfos != null);
            for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
                DocValuesType type = fieldInfo.getDocValuesType();
                if (type != DocValuesType.BINARY) continue;
                this.addKNNBinaryField(fieldInfo, (DocValuesProducer)new KNN80DocValuesReader(mergeState));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedSetField(field, valuesProducer);
    }

    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedNumericField(field, valuesProducer);
    }

    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedField(field, valuesProducer);
    }

    public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addNumericField(field, valuesProducer);
    }

    @Override
    public void close() throws IOException {
        this.delegatee.close();
    }

    private boolean isNmsLibLatest() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (!NmsLibVersion.LATEST.indexLibraryVersion().equals(KNNIndex.VERSION.indexLibraryVersion())) {
                    String errorMessage = String.format("KNN codec nms library version mis match. Latest version: %sCurrent version: %s", new Object[]{NmsLibVersion.LATEST.indexLibraryVersion(), KNNIndex.VERSION});
                    KNN80DocValuesConsumer.this.logger.error(errorMessage);
                    return false;
                }
                return true;
            }
        });
    }

    private String[] getKNNIndexParams(Map<String, String> fieldAttributes) {
        ArrayList<String> algoParams = new ArrayList<String>();
        if (fieldAttributes.containsKey("M")) {
            algoParams.add("M=" + fieldAttributes.get("M"));
        }
        if (fieldAttributes.containsKey("efConstruction")) {
            algoParams.add("efConstruction=" + fieldAttributes.get("efConstruction"));
        }
        algoParams.add("indexThreadQty=" + KNNSettings.state().getSettingValue("knn.algo_param.index_thread_qty"));
        return algoParams.toArray(new String[0]);
    }
}

