/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index.codec.KNN80Codec;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundDirectory;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class KNN80CompoundFormat
extends CompoundFormat {
    private final Logger logger = LogManager.getLogger(KNN80CompoundFormat.class);

    public CompoundDirectory getCompoundReader(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        return Codec.getDefault().compoundFormat().getCompoundReader(dir, si, context);
    }

    public void write(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        Set hnswFiles = si.files().stream().filter(file -> file.endsWith(".hnsw")).collect(Collectors.toSet());
        HashSet segmentFiles = new HashSet();
        segmentFiles.addAll(si.files());
        if (!hnswFiles.isEmpty()) {
            for (String hnswFile : hnswFiles) {
                String hnswCompoundFile = hnswFile + "c";
                dir.copyFrom(dir, hnswFile, hnswCompoundFile, context);
            }
            segmentFiles.removeAll(hnswFiles);
            si.setFiles(segmentFiles);
        }
        Codec.getDefault().compoundFormat().write(dir, si, context);
    }
}

