/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;

public class VectorField
extends Field {
    public VectorField(String name, float[] value, IndexableFieldType type) {
        super(name, new BytesRef(), type);
        try {
            this.setBytesValue(VectorField.floatToByte(value));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] floatToByte(float[] floats) throws Exception {
        byte[] bytes;
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);){
            objectStream.writeObject(floats);
            bytes = byteStream.toByteArray();
        }
        return bytes;
    }
}

