/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.knn.index;

import com.amazon.opendistroforelasticsearch.knn.index.KNNIndexCache;
import com.amazon.opendistroforelasticsearch.knn.index.KNNQuery;
import com.amazon.opendistroforelasticsearch.knn.index.KNNQueryResult;
import com.amazon.opendistroforelasticsearch.knn.index.KNNScorer;
import com.amazon.opendistroforelasticsearch.knn.index.v2011.KNNIndex;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.util.DocIdSetBuilder;
import org.elasticsearch.common.io.PathUtils;

public class KNNWeight
extends Weight {
    private static Logger logger = LogManager.getLogger(KNNWeight.class);
    private final KNNQuery knnQuery;
    private final float boost;
    public static KNNIndexCache knnIndexCache = KNNIndexCache.getInstance();

    public KNNWeight(KNNQuery query, float boost) {
        super((Query)query);
        this.knnQuery = query;
        this.boost = boost;
    }

    public Explanation explain(LeafReaderContext context, int doc) {
        return Explanation.match((Number)Float.valueOf(1.0f), (String)"No Explanation", (Explanation[])new Explanation[0]);
    }

    public void extractTerms(Set<Term> terms) {
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        SegmentReader reader = (SegmentReader)FilterLeafReader.unwrap((LeafReader)context.reader());
        String directory = ((FSDirectory)FilterDirectory.unwrap((Directory)reader.directory())).getDirectory().toString();
        String hnswFileExtension = reader.getSegmentInfo().info.getUseCompoundFile() ? ".hnswc" : ".hnsw";
        String hnswSuffix = this.knnQuery.getField() + hnswFileExtension;
        List hnswFiles = reader.getSegmentInfo().files().stream().filter(fileName -> fileName.endsWith(hnswSuffix)).collect(Collectors.toList());
        if (hnswFiles.isEmpty()) {
            logger.debug("[KNN] No hnsw index found for field {} for segment {}", (Object)this.knnQuery.getField(), (Object)reader.getSegmentName());
            return null;
        }
        FieldInfo queryFieldInfo = reader.getFieldInfos().fieldInfo(this.knnQuery.getField());
        Path indexPath = PathUtils.get((String)directory, (String[])new String[]{(String)hnswFiles.get(0)});
        KNNIndex index = knnIndexCache.getIndex(indexPath.toString(), this.knnQuery.getIndexName());
        KNNQueryResult[] results = index.queryIndex(this.knnQuery.getQueryVector(), this.knnQuery.getK());
        Map<Integer, Float> scores = Arrays.stream(results).collect(Collectors.toMap(result -> result.getId(), result -> Float.valueOf(1.0f / (1.0f + result.getScore()))));
        int maxDoc = Collections.max(scores.keySet()) + 1;
        DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(maxDoc);
        DocIdSetBuilder.BulkAdder setAdder = docIdSetBuilder.grow(maxDoc);
        Arrays.stream(results).forEach(result -> setAdder.add(result.getId()));
        DocIdSetIterator docIdSetIter = docIdSetBuilder.build().iterator();
        return new KNNScorer(this, docIdSetIter, scores, this.boost);
    }

    public boolean isCacheable(LeafReaderContext context) {
        return true;
    }
}

